/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zps.blockentity;

import g_mungus.zps.block.ModBlocks;
import g_mungus.zps.block.cableNetwork.TransformerBlock;
import g_mungus.zps.block.cableNetwork.core.NetworkNode;
import g_mungus.zps.blockentity.ModBlockEntities;
import g_mungus.zps.blockentity.NetworkTerminal;
import g_mungus.zps.blockentity.RedstoneReceivingTerminal;
import g_mungus.zps.blockentity.RedstoneSendingTerminal;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RedstoneConverterBlockEntity
extends NetworkTerminal
implements RedstoneSendingTerminal,
RedstoneReceivingTerminal {
    private int currentSignal = 0;
    private int currentSuppliedSignal = 0;

    public RedstoneConverterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.REDSTONE_CONVERTER.get(), pos, state);
    }

    public int getCurrentSignal() {
        return this.currentSignal;
    }

    @Override
    public int getCurrentSuppliedSignal(int channel) {
        return this.currentSuppliedSignal;
    }

    @Override
    public void defineTerminals(List<NetworkNode> terminals, int channel) {
        super.defineTerminals(terminals, channel);
        this.updateAllSignals(this.level, this.getTerminals(0));
    }

    public void supplySignal(int strength) {
        if (this.currentSuppliedSignal == strength) {
            return;
        }
        this.currentSuppliedSignal = strength;
        this.updateAllSignals(this.level, this.getTerminals(0));
    }

    @Override
    public void receiveSignal(int strength, int channel) {
        if (this.level == null) {
            return;
        }
        this.currentSignal = strength;
        BlockPos pos = this.getBlockPos();
        BlockState state = this.level.getBlockState(pos);
        this.level.updateNeighborsAt(pos, state.getBlock());
        if (state.is((Block)ModBlocks.REDSTONE_CONVERTER.get())) {
            BlockPos neighborPos = TransformerBlock.getFacingPos(pos, state);
            this.level.updateNeighborsAt(neighborPos, this.level.getBlockState(neighborPos).getBlock());
        }
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("CurrentSignal")) {
            this.currentSignal = tag.getInt("CurrentSignal");
        }
        if (tag.contains("CurrentSuppliedSignal")) {
            this.currentSuppliedSignal = tag.getInt("CurrentSuppliedSignal");
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("CurrentSignal", this.currentSignal);
        tag.putInt("CurrentSuppliedSignal", this.currentSuppliedSignal);
    }
}

