package io.github.ghasto69.happy_airships

import net.fabricmc.api.ModInitializer
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup
import net.minecraft.core.Registry
import net.minecraft.core.component.DataComponentType
import net.minecraft.core.component.DataComponents
import net.minecraft.core.registries.BuiltInRegistries
import net.minecraft.core.registries.Registries
import net.minecraft.network.chat.Component
import net.minecraft.resources.ResourceKey
import net.minecraft.resources.ResourceLocation
import net.minecraft.sounds.SoundEvents
import net.minecraft.tags.EntityTypeTags
import net.minecraft.world.entity.EquipmentSlot
import net.minecraft.world.item.CreativeModeTab
import net.minecraft.world.item.DyeColor
import net.minecraft.world.item.Item
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect
import net.minecraft.world.item.equipment.EquipmentAssets
import net.minecraft.world.item.equipment.Equippable
import org.slf4j.LoggerFactory

object HappyAirships : ModInitializer {
    const val id = "happy_airships"
    private val logger = LoggerFactory.getLogger(id)

    private val ENTITY_TYPE_HOLDER_GETTER =
        BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ENTITY_TYPE)

    val HARNESSES_WITH_PROPELLERS: Map<DyeColor, Item> = DyeColor.entries.associateWith { dyeColor ->
        val key = ResourceKey.create(
            Registries.ITEM,
            identifier("${dyeColor.serializedName}_harness_with_propeller")
        )
        Registry.register(
            BuiltInRegistries.ITEM, key.location(), Item(
                Item.Properties()
                    .component(
                        DataComponents.EQUIPPABLE, Equippable
                            .builder(EquipmentSlot.BODY)
                            .setEquipSound(SoundEvents.HARNESS_EQUIP)
                            .setAsset(EquipmentAssets.HARNESSES[dyeColor]!!)
                            .setAllowedEntities(ENTITY_TYPE_HOLDER_GETTER.getOrThrow(EntityTypeTags.CAN_EQUIP_HARNESS))
                            .setEquipOnInteract(true)
                            .setCanBeSheared(true)
                            .build()
                    )
                    .setId(key)
            )
        )
    }

    val PROPELLER_KEY: ResourceKey<Item> = ResourceKey.create(Registries.ITEM, identifier("propeller"))

    val PROPELLER: PropellerItem = Registry.register(
        BuiltInRegistries.ITEM,
        PROPELLER_KEY.location(),
        PropellerItem(Item.Properties().setId(PROPELLER_KEY))
    )

    val CREATIVE_MODE_TAB: ResourceKey<CreativeModeTab> = ResourceKey.create(
        Registries.CREATIVE_MODE_TAB, identifier("creative_mode_tab")
    )

    val SWIFTNESS_EFFECT: DataComponentType<EnchantmentValueEffect> = Registry.register(
        BuiltInRegistries.ENCHANTMENT_EFFECT_COMPONENT_TYPE,
        identifier("swiftness"),
        DataComponentType.builder<EnchantmentValueEffect>().persistent(EnchantmentValueEffect.CODEC).build()
    )

    override fun onInitialize() {
        Registry.register(
            BuiltInRegistries.CREATIVE_MODE_TAB,
            CREATIVE_MODE_TAB.location(),
            FabricItemGroup.builder().title(Component.translatable("creative_mode_tab.happy_air_travel"))
                .icon { HARNESSES_WITH_PROPELLERS[DyeColor.RED]!!.defaultInstance }
                .displayItems { _, output ->
                    for ((_, item) in HARNESSES_WITH_PROPELLERS) output.accept(item)
                    output.accept(PROPELLER)
                }.build()
        )
    }

    fun identifier(path: String): ResourceLocation = ResourceLocation.fromNamespaceAndPath(id, path)
}