package io.github.ghasto69.happy_airships

import io.github.ghasto69.happy_airships.HappyAirships.SWIFTNESS_EFFECT
import io.github.ghasto69.happy_airships.datagen.ModItemTags.Companion.HARNESSES_WITH_PROPELLERS
import net.minecraft.world.entity.animal.HappyGhast
import net.minecraft.world.item.ItemStack

object HappyGhastMixinBacker {
    fun HappyGhast.modifyFlySpeed(original: Double): Double {
        val bodyArmorItem: ItemStack = this.bodyArmorItem

        if (bodyArmorItem.`is`(HARNESSES_WITH_PROPELLERS)) {
            var multiplier = 2f
            for ((holder, level) in bodyArmorItem.enchantments.entrySet()) {
                val effect = holder.value().effects().get(SWIFTNESS_EFFECT) ?: continue
                multiplier = effect.process(level, this.getRandom(), multiplier)
            }
            return original * multiplier
        }

        return original
    }
}