package io.github.ghasto69.happy_airships

import io.github.ghasto69.happy_airships.HappyAirships.HARNESSES_WITH_PROPELLERS
import io.github.ghasto69.happy_airships.datagen.ModAdvancements
import io.github.ghasto69.happy_airships.datagen.ModEnchantments
import net.minecraft.ChatFormatting
import net.minecraft.network.chat.Component
import net.minecraft.server.level.ServerPlayer
import net.minecraft.world.InteractionHand
import net.minecraft.world.InteractionResult
import net.minecraft.world.entity.LivingEntity
import net.minecraft.world.entity.animal.HappyGhast
import net.minecraft.world.entity.player.Player
import net.minecraft.world.item.DyeColor
import net.minecraft.world.item.Item
import net.minecraft.world.item.ItemStack
import net.minecraft.world.item.Items
import net.minecraft.world.item.TooltipFlag
import net.minecraft.world.item.component.TooltipDisplay
import net.minecraft.world.item.enchantment.EnchantmentHelper
import net.minecraft.world.level.Level
import java.util.function.Consumer

class PropellerItem(properties: Properties) : Item(properties) {
    companion object {
        const val TOOLTIP_KEY = "tooltip.happy-air-travel.propeller"

        fun awardAdvancement(player: Player) {
            val server = player.level().server ?: return
            val advancementManager = server.advancements
            val happyAirship = advancementManager.get(ModAdvancements.HAPPY_AIRSHIP)
                ?: return

            player as ServerPlayer
            player.advancements.award(happyAirship, "trigger")
        }
    }

/*    override fun appendHoverText(
        itemStack: ItemStack,
        tooltipContext: TooltipContext,
        tooltipDisplay: TooltipDisplay,
        consumer: Consumer<Component>,
        tooltipFlag: TooltipFlag
    ) {
        consumer.accept(Component.translatable(TOOLTIP_KEY).withStyle(ChatFormatting.GRAY))
    }*/

    override fun interactLivingEntity(
        itemStack: ItemStack,
        player: Player,
        entity: LivingEntity,
        hand: InteractionHand
    ): InteractionResult {
        val level = player.level()
        if (!level.isClientSide && hand == InteractionHand.MAIN_HAND) {
            if (entity is HappyGhast) {
                val handItem = player.getItemInHand(hand)
                if(handItem.item != HappyAirships.PROPELLER) return InteractionResult.PASS

                val harnessWithPropeller = when(entity.bodyArmorItem.item) {
                    Items.WHITE_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.WHITE]
                    Items.ORANGE_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.ORANGE]
                    Items.MAGENTA_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.MAGENTA]
                    Items.LIGHT_BLUE_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.LIGHT_BLUE]
                    Items.YELLOW_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.YELLOW]
                    Items.LIME_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.LIME]
                    Items.PINK_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.PINK]
                    Items.GRAY_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.GRAY]
                    Items.LIGHT_GRAY_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.LIGHT_GRAY]
                    Items.CYAN_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.CYAN]
                    Items.PURPLE_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.PURPLE]
                    Items.BLUE_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.BLUE]
                    Items.BROWN_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.BROWN]
                    Items.GREEN_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.GREEN]
                    Items.RED_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.RED]
                    Items.BLACK_HARNESS -> HARNESSES_WITH_PROPELLERS[DyeColor.BLACK]
                    else -> null
                }

                if(harnessWithPropeller != null) {
                    entity.bodyArmorItem = harnessWithPropeller.defaultInstance

                    val enchantment = player.registryAccess().getOrThrow(ModEnchantments.SWIFTNESS)
                    val level = handItem.enchantments.getLevel(enchantment)
                    if(level > 0) {
                        entity.bodyArmorItem.enchant(enchantment, level)
                    }

                    handItem.consume(1, player)

                    awardAdvancement(player)

                    return InteractionResult.SUCCESS
                }
            }
        }

        return InteractionResult.PASS
    }
}