package io.github.ghasto69.happy_airships.datagen

import io.github.ghasto69.happy_airships.HappyAirships
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider
import net.minecraft.advancements.Advancement
import net.minecraft.advancements.AdvancementHolder
import net.minecraft.advancements.AdvancementType
import net.minecraft.advancements.CriteriaTriggers
import net.minecraft.advancements.critereon.ImpossibleTrigger
import net.minecraft.core.HolderLookup
import net.minecraft.network.chat.Component
import net.minecraft.resources.ResourceLocation
import java.util.concurrent.CompletableFuture
import java.util.function.Consumer

class ModAdvancements(output: FabricDataOutput, registryLookup: CompletableFuture<HolderLookup.Provider>) :
    FabricAdvancementProvider(output, registryLookup) {
    companion object {
        const val HAPPY_AIRSHIP_NAME_KEY = "advancement.happy_airships.happy_airship"
        const val HAPPY_AIRSHIP_DESCRIPTION_KEY = "advancement.happy_airships.happy_airship.description"
        val HAPPY_AIRSHIP = HappyAirships.identifier("husbandry/happy_airship")
    }

    override fun generateAdvancement(
        registryLookup: HolderLookup.Provider,
        consumer: Consumer<AdvancementHolder>
    ) {
        val happyAirship = Advancement.Builder.advancement()
            .parent(ResourceLocation.withDefaultNamespace("husbandry/place_dried_ghast_in_water"))
            .display(
                HappyAirships.PROPELLER,
                Component.translatable(HAPPY_AIRSHIP_NAME_KEY),
                Component.translatable(HAPPY_AIRSHIP_DESCRIPTION_KEY),
                null,
                AdvancementType.TASK,
                true,
                true,
                false
            )
            .addCriterion("trigger", CriteriaTriggers.IMPOSSIBLE.createCriterion(ImpossibleTrigger.TriggerInstance()))
            .build(HAPPY_AIRSHIP)

        consumer.accept(happyAirship)
    }
}