package io.github.ghasto69.happy_airships

import io.github.ghasto69.happy_airships.datagen.*
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator
import net.minecraft.core.RegistrySetBuilder
import net.minecraft.core.registries.Registries

object HappyAirshipsDataGenerator : DataGeneratorEntrypoint {
    override fun onInitializeDataGenerator(dataGenerator: FabricDataGenerator) {
        val pack = dataGenerator.createPack()
        pack.addProvider(::ModItemTags)
        pack.addProvider(::ModModelProvider)
        pack.addProvider(::ModTranslationProvider)
        pack.addProvider(::ModRecipeProvider)
        pack.addProvider(::ModAdvancements)
        pack.addProvider(::ModDynamicRegistryProvider)
        pack.addProvider(::ModEnchantmentTags)
    }

    override fun buildRegistry(registryBuilder: RegistrySetBuilder) {
        registryBuilder.add(Registries.ENCHANTMENT, ModEnchantments)
    }
}