package io.github.ghasto69.happy_airships.datagen

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider
import net.minecraft.core.HolderLookup
import net.minecraft.core.Registry
import net.minecraft.core.registries.Registries
import net.minecraft.resources.ResourceKey
import net.minecraft.tags.EnchantmentTags
import net.minecraft.world.item.enchantment.Enchantment
import java.util.concurrent.CompletableFuture

class ModEnchantmentTags(
    output: FabricDataOutput,
    registriesFuture: CompletableFuture<HolderLookup.Provider>
) : FabricTagProvider<Enchantment>(output, Registries.ENCHANTMENT, registriesFuture) {
    override fun addTags(registries: HolderLookup.Provider) {
        builder(EnchantmentTags.NON_TREASURE)
            .add(ModEnchantments.SWIFTNESS)
    }
}