package io.github.ghasto69.happy_airships.datagen

import io.github.ghasto69.happy_airships.HappyAirships
import net.minecraft.core.RegistrySetBuilder
import net.minecraft.core.registries.Registries
import net.minecraft.data.worldgen.BootstrapContext
import net.minecraft.resources.ResourceKey
import net.minecraft.world.entity.EquipmentSlotGroup
import net.minecraft.world.item.enchantment.Enchantment
import net.minecraft.world.item.enchantment.LevelBasedValue
import net.minecraft.world.item.enchantment.effects.AddValue

object ModEnchantments : RegistrySetBuilder.RegistryBootstrap<Enchantment> {
    val SWIFTNESS: ResourceKey<Enchantment> = ResourceKey.create(Registries.ENCHANTMENT, HappyAirships.identifier("swiftness"))

    override fun run(bootstrapContext: BootstrapContext<Enchantment>) {
        val items = bootstrapContext.lookup(Registries.ITEM)

        bootstrapContext.register(SWIFTNESS, Enchantment.enchantment(Enchantment.definition(
            items.getOrThrow(ModItemTags.SWIFTNESS_ENCHANTABLE),
            1,
            2,
            Enchantment.dynamicCost(1, 1),
            Enchantment.dynamicCost(2, 2),
            1,
            EquipmentSlotGroup.BODY
        ))
            .withSpecialEffect(HappyAirships.SWIFTNESS_EFFECT, AddValue(LevelBasedValue.perLevel(0.5F)))
            .build(SWIFTNESS.location())
        )
    }
}