package io.github.ghasto69.happy_airships.datagen

import io.github.ghasto69.happy_airships.HappyAirships
import io.github.ghasto69.happy_airships.HappyAirships.identifier
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider.ItemTagProvider
import net.minecraft.core.HolderLookup
import net.minecraft.core.registries.Registries
import net.minecraft.tags.ItemTags
import net.minecraft.tags.TagKey
import net.minecraft.world.item.Item
import java.util.concurrent.CompletableFuture

class ModItemTags(output: FabricDataOutput, registriesFuture: CompletableFuture<HolderLookup.Provider>) :
    ItemTagProvider(output, registriesFuture) {
    companion object {
        fun create(name: String): TagKey<Item> = TagKey.create(Registries.ITEM, identifier(name))

        val HARNESSES_WITH_PROPELLERS = create("harnesses_with_propellers")
        val SWIFTNESS_ENCHANTABLE = create("swiftness_enchantable")
    }

    override fun addTags(wrapperLookup: HolderLookup.Provider) {
        valueLookupBuilder(ItemTags.HARNESSES)
            .addAll(HappyAirships.HARNESSES_WITH_PROPELLERS.values)
        valueLookupBuilder(HARNESSES_WITH_PROPELLERS)
            .addAll(HappyAirships.HARNESSES_WITH_PROPELLERS.values)
        valueLookupBuilder(SWIFTNESS_ENCHANTABLE)
            .forceAddTag(HARNESSES_WITH_PROPELLERS)
            .add(HappyAirships.PROPELLER)
    }
}