package io.github.ghasto69.happy_airships.datagen

import io.github.ghasto69.happy_airships.HappyAirships
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput
import net.minecraft.client.data.models.BlockModelGenerators
import net.minecraft.client.data.models.ItemModelGenerators
import net.minecraft.client.data.models.model.ModelTemplates
import kotlin.collections.component1
import kotlin.collections.component2
import kotlin.collections.iterator

class ModModelProvider(output: FabricDataOutput) : FabricModelProvider(output) {
    override fun generateBlockStateModels(generator: BlockModelGenerators) {

    }

    override fun generateItemModels(generator: ItemModelGenerators) {
        generator.generateFlatItem(HappyAirships.PROPELLER, ModelTemplates.FLAT_ITEM)
        for ((color, item) in HappyAirships.HARNESSES_WITH_PROPELLERS) {
            generator.generateFlatItem(item, ModelTemplates.FLAT_ITEM)
        }
    }
}