package io.github.ghasto69.happy_airships.datagen

import io.github.ghasto69.happy_airships.HappyAirships
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider
import net.minecraft.core.HolderLookup
import net.minecraft.data.recipes.RecipeCategory
import net.minecraft.data.recipes.RecipeOutput
import net.minecraft.data.recipes.RecipeProvider
import net.minecraft.tags.ItemTags
import net.minecraft.world.item.DyeColor
import net.minecraft.world.item.Items
import java.util.concurrent.CompletableFuture
import kotlin.collections.component1
import kotlin.collections.component2
import kotlin.collections.iterator

class ModRecipeProvider(output: FabricDataOutput, registriesFuture: CompletableFuture<HolderLookup.Provider>) :
    FabricRecipeProvider(output, registriesFuture) {

    override fun createRecipeProvider(
        registryLookup: HolderLookup.Provider,
        exporter: RecipeOutput
    ) = object : RecipeProvider(registryLookup, exporter) {
        override fun buildRecipes() {
            shaped(RecipeCategory.MISC, HappyAirships.PROPELLER)
                .pattern(" I ")
                .pattern("IWI")
                .pattern(" I ")
                .define('I', Items.IRON_INGOT)
                .define('W', ItemTags.LOGS)
                .unlockedBy("has_iron_ingot", has(Items.IRON_INGOT))
                .save(exporter)

            for ((color, item) in HappyAirships.HARNESSES_WITH_PROPELLERS) {
                shapeless(RecipeCategory.MISC, item)
                    .requires(HappyAirships.PROPELLER)
                    .requires(
                        when (color) {
                            DyeColor.WHITE -> Items.WHITE_HARNESS
                            DyeColor.ORANGE -> Items.ORANGE_HARNESS
                            DyeColor.MAGENTA -> Items.MAGENTA_HARNESS
                            DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_HARNESS
                            DyeColor.YELLOW -> Items.YELLOW_HARNESS
                            DyeColor.LIME -> Items.LIME_HARNESS
                            DyeColor.PINK -> Items.PINK_HARNESS
                            DyeColor.GRAY -> Items.GRAY_HARNESS
                            DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_HARNESS
                            DyeColor.CYAN -> Items.CYAN_HARNESS
                            DyeColor.PURPLE -> Items.PURPLE_HARNESS
                            DyeColor.BLUE -> Items.BLUE_HARNESS
                            DyeColor.BROWN -> Items.BROWN_HARNESS
                            DyeColor.GREEN -> Items.GREEN_HARNESS
                            DyeColor.RED -> Items.RED_HARNESS
                            DyeColor.BLACK -> Items.BLACK_HARNESS
                        }
                    )
                    .unlockedBy("has_propeller", has(HappyAirships.PROPELLER))
                    .save(exporter)
            }
        }
    }

    override fun getName() = "Recipes"
}
