package io.github.ghasto69.happy_airships.datagen

import io.github.ghasto69.happy_airships.HappyAirships
import io.github.ghasto69.happy_airships.PropellerItem
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider
import net.minecraft.core.HolderLookup
import net.minecraft.world.item.DyeColor
import java.util.concurrent.CompletableFuture

class ModTranslationProvider(
    dataOutput: FabricDataOutput,
    registryLookup: CompletableFuture<HolderLookup.Provider>
) : FabricLanguageProvider(dataOutput, registryLookup) {
    override fun generateTranslations(
        holderLookup: HolderLookup.Provider,
        translations: TranslationBuilder
    ) {
        translations.add(HappyAirships.CREATIVE_MODE_TAB, "Happy Airships")
        translations.add(HappyAirships.PROPELLER, "Propeller")
        for ((color, item) in HappyAirships.HARNESSES_WITH_PROPELLERS) {
            translations.add(
                item, when (color) {
                    DyeColor.WHITE -> "White"
                    DyeColor.ORANGE -> "Orange"
                    DyeColor.MAGENTA -> "Magenta"
                    DyeColor.LIGHT_BLUE -> "Light Blue"
                    DyeColor.YELLOW -> "Yellow"
                    DyeColor.LIME -> "Lime"
                    DyeColor.PINK -> "Pink"
                    DyeColor.GRAY -> "Gray"
                    DyeColor.LIGHT_GRAY -> "Light Gray"
                    DyeColor.CYAN -> "Cyan"
                    DyeColor.PURPLE -> "Purple"
                    DyeColor.BLUE -> "Blue"
                    DyeColor.BROWN -> "Brown"
                    DyeColor.GREEN -> "Green"
                    DyeColor.RED -> "Red"
                    DyeColor.BLACK -> "Black"
                } + " Harness With Propeller"
            )
        }
        translations.add(PropellerItem.TOOLTIP_KEY, "Equip onto a happy ghast for an exciting boost!")
        translations.add(ModAdvancements.HAPPY_AIRSHIP_NAME_KEY, "Happy Airship")
        translations.add(ModAdvancements.HAPPY_AIRSHIP_DESCRIPTION_KEY, "Equip a propeller onto your happy ghast")
        translations.add("enchantment.happy_airships.swiftness", "Swiftness")
    }
}