/*
 * Decompiled with CFR 0.152.
 */
package io.github.ghasto69.happy_airships;

import com.blackgear.vanillabackport.client.level.entities.model.HappyGhastModel;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Axis;
import io.github.ghasto69.happy_airships.ExampleMod;
import io.github.ghasto69.happy_airships.HAItemTags;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

public class PropellerLayer
extends RenderLayer<HappyGhast, HappyGhastModel<HappyGhast>> {
    private static final ResourceLocation RENDER_TYPE_ID = ExampleMod.id("textures/entity/happy_ghast/propeller.png");

    public PropellerLayer(RenderLayerParent<HappyGhast, HappyGhastModel<HappyGhast>> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, HappyGhast entity, float f, float g, float partialTick, float j, float k, float l) {
        if (!entity.getItemBySlot(EquipmentSlot.CHEST).is(HAItemTags.HARNESSES_WITH_PROPELLERS)) {
            return;
        }
        poseStack.pushPose();
        boolean glint = entity.getItemBySlot(EquipmentSlot.CHEST).hasFoil();
        VertexConsumer glintVertexConsumer = multiBufferSource.getBuffer(RenderType.entityGlint());
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)RENDER_TYPE_ID));
        if (glint) {
            vertexConsumer = VertexMultiConsumer.create((VertexConsumer)glintVertexConsumer, (VertexConsumer)vertexConsumer);
        }
        poseStack.scale(0.25f, 0.25f, 0.25f);
        poseStack.translate(0.0f, 4.5f, 0.0f);
        poseStack.translate(-2.0f, -2.5f, 2.125f);
        poseStack.translate(2.0f, 2.0f, 0.0f);
        float time = (float)entity.tickCount + partialTick;
        float rotation = time * (entity.getPassengers().isEmpty() ? 0.1f : 1.0f) * 20.0f % 360.0f;
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
        poseStack.translate(-2.0f, -2.0f, 0.0f);
        List<Vertex> vertices = List.of(new Vertex(0.0f, 0.0f, 0.0f, 0.0f, 1.0f), new Vertex(4.0f, 0.0f, 0.0f, 1.0f, 1.0f), new Vertex(4.0f, 4.0f, 0.0f, 1.0f, 0.0f), new Vertex(0.0f, 4.0f, 0.0f, 0.0f, 0.0f));
        for (Vertex v : vertices) {
            vertexConsumer.addVertex(poseStack.last(), v.x(), v.y(), v.z()).setColor(255, 255, 255, 255).setUv(v.u(), v.v()).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 1.0f).setLight(light);
        }
        poseStack.popPose();
        ResourceLocation plankTexture = ResourceLocation.withDefaultNamespace((String)"textures/block/dark_oak_planks.png");
        VertexConsumer planksConsumer = multiBufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)plankTexture));
        if (glint) {
            planksConsumer = VertexMultiConsumer.create((VertexConsumer)glintVertexConsumer, (VertexConsumer)planksConsumer);
        }
        List<Vertex> woodenVertices = List.of(new Vertex(0.0f, 0.0f, 0.0f, 0.0f, 0.25f), new Vertex(0.125f, 0.0f, 0.0f, 0.0625f, 0.25f), new Vertex(0.125f, 0.5f, 0.0f, 0.0625f, 0.0f), new Vertex(0.0f, 0.5f, 0.0f, 0.0f, 0.0f));
        poseStack.pushPose();
        poseStack.scale(0.25f, 0.25f, 0.25f);
        poseStack.translate(0.0f, 4.5f, 0.0f);
        poseStack.translate(0.25f, -0.5f, 2.125f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        for (Vertex v : woodenVertices) {
            planksConsumer.addVertex(poseStack.last(), v.x(), v.y(), v.z()).setColor(255, 255, 255, 255).setUv(v.u(), v.v()).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setLight(light);
        }
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.25f, 0.25f, 0.25f);
        poseStack.translate(0.0f, 4.5f, 0.0f);
        poseStack.translate(0.0f, -0.75f, 2.125f);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        for (Vertex v : woodenVertices) {
            planksConsumer.addVertex(poseStack.last(), v.x(), v.y(), v.z()).setColor(255, 255, 255, 255).setUv(v.u(), v.v()).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(1.0f, 0.0f, 0.0f).setLight(light);
        }
        poseStack.popPose();
    }

    private record Vertex(float x, float y, float z, float u, float v) {
    }
}

