/*
 * Decompiled with CFR 0.152.
 */
package com.ashbill.trainresync;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="trainresync", value={Dist.CLIENT})
public class ClientInit {
    private static ResourceKey<Level> lastDimension = null;
    private static int syncCooldown = 0;
    private static final Map<Entity, Integer> checkQueue = new HashMap<Entity, Integer>();
    private static int messageCooldown = -1;
    private static boolean isDebugMode = false;

    public static void init() {
        MinecraftForge.EVENT_BUS.register(ClientInit.class);
    }

    @SubscribeEvent
    public static void onClientCommandRegister(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"shuaxin").executes(ctx -> ClientInit.resyncAllCarriages()));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"xuebaobizui").executes(ctx -> ClientInit.silentMode()));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"verbose").executes(ctx -> ClientInit.verboseMode()));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"trainresyncdebug").executes(ctx -> ClientInit.debugMode()));
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_46472_() == Level.f_46428_) {
            checkQueue.put(event.getEntity(), 5);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        try {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            ResourceKey currentDimension = mc.f_91073_.m_46472_();
            if (currentDimension == Level.f_46428_ && lastDimension == Level.f_46429_) {
                if (syncCooldown == 0) {
                    ClientInit.showMessage("[AshBill TrainResync] \u5373\u5c06\u81ea\u52a8\u5237\u65b0");
                }
                if (syncCooldown < 60) {
                    syncCooldown = 60;
                }
            }
            lastDimension = currentDimension;
            if (syncCooldown > 0 && --syncCooldown == 0 && currentDimension == Level.f_46428_) {
                ClientInit.resyncAllCarriages();
            }
            Iterator<Map.Entry<Entity, Integer>> iter = checkQueue.entrySet().iterator();
            while (iter.hasNext()) {
                CarriageContraption cc;
                CarriageContraptionEntity cce;
                Contraption contraption;
                Map.Entry<Entity, Integer> entry = iter.next();
                Entity e = entry.getKey();
                int t = entry.getValue();
                if (t > 1) {
                    entry.setValue(t - 1);
                    continue;
                }
                if (e != null && currentDimension == Level.f_46428_ && (e.m_20202_() instanceof CarriageContraptionEntity || e instanceof CarriageContraptionEntity && (contraption = (cce = (CarriageContraptionEntity)e).getContraption()) instanceof CarriageContraption && !(cc = (CarriageContraption)contraption).notInPortal())) {
                    if (syncCooldown == 0) {
                        ClientInit.showMessage("[AshBill TrainResync] \u5373\u5c06\u81ea\u52a8\u5237\u65b0");
                    }
                    if (syncCooldown < 40) {
                        syncCooldown = 40;
                    }
                }
                iter.remove();
            }
            if (messageCooldown > 0) {
                --messageCooldown;
            }
            if (isDebugMode) {
                ClientInit.showMessage("sync: " + syncCooldown + ", len(cQ): " + checkQueue.size() + ", msg: " + messageCooldown, -1);
            }
        }
        catch (Exception t) {
            ClientInit.showMessage("[AshBill TrainResync] \u5237\u65b0\u5931\u8d25\uff08" + t.getClass().getSimpleName() + "\uff09", -1);
        }
    }

    public static int resyncAllCarriages() {
        try {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null || mc.f_91074_ == null) {
                return -1;
            }
            for (Entity e : mc.f_91073_.m_104735_()) {
                if (!(e instanceof CarriageContraptionEntity)) continue;
                e.m_6034_(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_() - 512.0, mc.f_91074_.m_20189_());
            }
            ClientInit.showMessage("[AshBill TrainResync] \u5df2\u5237\u65b0\u5217\u8f66\u72b6\u6001", 18000);
            return 0;
        }
        catch (Exception t) {
            ClientInit.showMessage("[AshBill TrainResync] \u5237\u65b0\u5931\u8d25\uff08" + t.getClass().getSimpleName() + "\uff09", -1);
            return -1;
        }
    }

    public static int silentMode() {
        messageCooldown = -2;
        ClientInit.showMessage("[AshBill TrainResync] \u63d0\u793a\u5df2\u5173\u95ed", -1);
        return 0;
    }

    public static int verboseMode() {
        messageCooldown = -3;
        return 0;
    }

    public static int debugMode() {
        isDebugMode = true;
        return 0;
    }

    public static void showMessage(String msg) {
        ClientInit.showMessage(msg, 0);
    }

    public static void showMessage(String msg, int cooldown) {
        if (messageCooldown == -1) {
            msg = (String)msg + "\uff0c\u5173\u95ed\u6b64\u63d0\u793a\uff1a/xuebaobizui";
            messageCooldown = 0;
        }
        if (messageCooldown == -2 && cooldown != -1) {
            return;
        }
        if (messageCooldown < 36000 || cooldown == -1) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91074_.m_213846_((Component)Component.m_237113_((String)msg));
            }
            if (messageCooldown != -3 && cooldown != -1) {
                messageCooldown += cooldown;
            }
        }
    }
}

