/*
 * Decompiled with CFR 0.152.
 */
package com.ashbill.trainresync.mixin;

import com.ashbill.trainresync.mixin.accessor.PantographBlockEntityAccessor;
import com.ashbill.trainresync.mixin_interfaces.IElectricTrainCarriage;
import com.ashbill.trainresync.mixin_interfaces.IElectricTrainContraption;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.foundation.utility.NBTHelper;
import de.mrjulsen.paw.blockentity.PantographBlockEntity;
import de.mrjulsen.wires.WiresApi;
import de.mrjulsen.wires.graph.WireGraph;
import de.mrjulsen.wires.graph.WireGraphManager;
import de.mrjulsen.wires.util.GraphId;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Carriage.class}, remap=false)
public abstract class CarriageMixin
implements IElectricTrainCarriage {
    @Unique
    private final Quaternionf trainresync$initialRotation = new Quaternionf();
    @Unique
    private final Set<BlockPos> trainresync$pantographs = new HashSet<BlockPos>();

    @Shadow
    public abstract Carriage.DimensionalCarriageEntity getDimensional(Level var1);

    @Inject(method={"setContraption"}, at={@At(value="RETURN")})
    private void trainresync$findPantographs(Level level, CarriageContraption contraption, CallbackInfo ci, @Local Carriage.DimensionalCarriageEntity dimensional) {
        this.trainresync$setInitialRotation(CarriageMixin.getCarriageRotation(dimensional));
        this.trainresync$setPantographs(((IElectricTrainContraption)contraption).trainresync$getPantographs());
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void trainresync$savePantographs(DimensionPalette dimensions, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        Vector3f euler = new Vector3f();
        this.trainresync$initialRotation.getEulerAnglesYXZ(euler);
        tag.m_128350_("Trainresync$InitialRotation", euler.y);
        tag.m_128365_("Trainresync$Pantographs", (Tag)NBTHelper.writeCompoundList(this.trainresync$pantographs, NbtUtils::m_129224_));
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void trainresync$loadPantographs(CompoundTag tag, TrackGraph graph, DimensionPalette dimensions, CallbackInfoReturnable<Carriage> cir) {
        Carriage carriage = (Carriage)cir.getReturnValue();
        ((IElectricTrainCarriage)carriage).trainresync$setInitialRotation(new Quaternionf().rotationYXZ(tag.m_128457_("Trainresync$InitialRotation"), 0.0f, 0.0f));
        HashSet<BlockPos> pantographs = new HashSet<BlockPos>();
        NBTHelper.iterateCompoundList((ListTag)tag.m_128437_("Trainresync$Pantographs", 10), c -> pantographs.add(NbtUtils.m_129239_((CompoundTag)c)));
        ((IElectricTrainCarriage)carriage).trainresync$setPantographs(pantographs);
    }

    @Unique
    private static Quaternionf getCarriageRotation(Carriage.DimensionalCarriageEntity dce) {
        Quaternionf rotation = new Quaternionf().rotationTo((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), (Vector3fc)((Vec3)dce.rotationAnchors.get(false)).m_82546_((Vec3)dce.rotationAnchors.get(true)).m_252839_());
        Vector3f euler = new Vector3f();
        rotation.getEulerAnglesYXZ(euler);
        rotation.rotationYXZ(euler.y, euler.x, 0.0f);
        return rotation;
    }

    @Override
    public void trainresync$setInitialRotation(Quaternionf initialRotation) {
        this.trainresync$initialRotation.set((Quaternionfc)initialRotation);
    }

    @Override
    public void trainresync$setPantographs(Set<BlockPos> pantographs) {
        this.trainresync$pantographs.clear();
        this.trainresync$pantographs.addAll(pantographs);
    }

    @Override
    public int trainresync$getPantographCount() {
        return this.trainresync$pantographs.size();
    }

    @Override
    public boolean trainresync$hasElectricity(Level level) {
        Carriage.DimensionalCarriageEntity dce = this.getDimensional(level);
        for (BlockPos pantograph : this.trainresync$pantographs) {
            Quaternionf rotation = CarriageMixin.getCarriageRotation(dce);
            Vector3f location = dce.positionAnchor.m_252839_().add((Vector3fc)rotation.transform(this.trainresync$initialRotation.transformInverse(Vec3.m_82528_((Vec3i)pantograph).m_252839_())));
            WireGraph wiregraph = WireGraphManager.get((Level)level, (GraphId)WiresApi.PAW_CATENARY_WIRES);
            Vector3f rightVector = rotation.transform(new Vector3f().set((Vector3dc)PantographBlockEntity.BASE_RIGHT_VECTOR));
            for (BlockPos pos : PantographBlockEntityAccessor.trainresync$callFindIntersectingBlocks(new Vector3d((Vector3fc)location).sub((Vector3fc)rightVector), new Vector3d((Vector3fc)location).add((Vector3fc)rightVector), rotation.transform(new Vector3d((Vector3dc)PantographBlockEntity.BASE_UP_VECTOR)))) {
                if (wiregraph.getCollisionsInBlock(pos).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

