/*
 * Decompiled with CFR 0.152.
 */
package com.ashbill.trainresync.mixin;

import com.ashbill.trainresync.mixin_interfaces.IElectricTrain;
import com.ashbill.trainresync.mixin_interfaces.IElectricTrainCarriage;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainStatus;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackGraph;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Train.class}, remap=false)
public abstract class TrainMixin
implements IElectricTrain {
    @Shadow
    public int fuelTicks;
    @Shadow
    public TrainStatus status;
    @Unique
    private boolean trainresync$isFirstTick = true;
    @Shadow
    public List<Carriage> carriages;

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void trainresync$skipFirstTickInformationOnLoad(CompoundTag tag, Map<UUID, TrackGraph> trackNetworks, DimensionPalette dimensions, CallbackInfoReturnable<Train> cir) {
        ((IElectricTrain)cir.getReturnValue()).trainresync$skipFirstTickInformation();
    }

    @Inject(method={"earlyTick"}, at={@At(value="HEAD")})
    private void trainresync$electricityIsFuel(Level level, CallbackInfo ci) {
        if (level.f_46443_) {
            return;
        }
        if (this.trainresync$isFirstTick) {
            this.trainresync$isFirstTick = false;
            int count = 0;
            for (Carriage carriage : this.carriages) {
                count += ((IElectricTrainCarriage)carriage).trainresync$getPantographCount();
            }
            if (count > 0) {
                this.status.displayInformation("has_pantograph", true, new Object[]{count});
            }
        }
        if (this.fuelTicks < 5 && this.trainresync$hasElectricity(level)) {
            this.fuelTicks = 25;
        }
    }

    @Unique
    private boolean trainresync$hasElectricity(Level level) {
        for (Carriage carriage : this.carriages) {
            if (!((IElectricTrainCarriage)carriage).trainresync$hasElectricity(level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void trainresync$skipFirstTickInformation() {
        this.trainresync$isFirstTick = false;
    }
}

