/*
 * Decompiled with CFR 0.152.
 */
package be.bismuth.longscorestat.network;

import be.bismuth.longscorestat.LongScoreStat;
import be.bismuth.longscorestat.network.ClientNetworkHandler;
import be.bismuth.longscorestat.network.LongscorestatPacket;
import be.bismuth.longscorestat.network.StatisticsPacket;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.ornithemc.osl.networking.api.client.ClientPlayNetworking;

public class ClientNetworking {
    private final Set<String> allChannels = new HashSet<String>();

    public ClientNetworking() {
        this.registerListener(StatisticsPacket::new, ClientNetworkHandler::handleStatistics);
    }

    private <T extends LongscorestatPacket> void registerListener(Supplier<T> initializer, Consumer<T> packetHandler) {
        LongscorestatPacket p = (LongscorestatPacket)initializer.get();
        String channel = p.getChannel();
        if (this.allChannels.contains(channel)) {
            LongScoreStat.LOGGER.error("Attempted to register packet '{}' on channel '{}' but it already exists!", (Object)p.getClass().getSimpleName(), (Object)channel);
        } else {
            this.allChannels.add(channel);
            ClientPlayNetworking.registerListener((String)channel, initializer, (minecraft, handler, packet) -> {
                packetHandler.accept(packet);
                return true;
            });
        }
    }
}

