/*
 * Decompiled with CFR 0.152.
 */
package be.bismuth.longscorestat.stats;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.class_156;

public interface LongStatFormatter {
    public static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)class_156.method_654((Object)new DecimalFormat("########0.00"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
    public static final LongStatFormatter DEFAULT = NumberFormat.getIntegerInstance(Locale.US)::format;
    public static final LongStatFormatter DIVIDE_BY_TEN = i -> DECIMAL_FORMAT.format((double)i * 0.1);
    public static final LongStatFormatter DISTANCE = i -> {
        double d = (double)i / 100.0;
        double e = d / 1000.0;
        if (e > 0.5) {
            return DECIMAL_FORMAT.format(e) + " km";
        }
        return d > 0.5 ? DECIMAL_FORMAT.format(d) + " m" : i + " cm";
    };
    public static final LongStatFormatter TIME = i -> {
        double d = (double)i / 20.0;
        double e = d / 60.0;
        double f = e / 60.0;
        double g = f / 24.0;
        double h = g / 365.0;
        if (h > 0.5) {
            return DECIMAL_FORMAT.format(h) + " y";
        }
        if (g > 0.5) {
            return DECIMAL_FORMAT.format(g) + " d";
        }
        if (f > 0.5) {
            return DECIMAL_FORMAT.format(f) + " h";
        }
        return e > 0.5 ? DECIMAL_FORMAT.format(e) + " m" : d + " s";
    };

    public String bismuthServer$format(long var1);
}

