/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs.gui.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.client.sound.SoundManager;
import net.minecraft.text.TranslatableText;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.lwjgl.Sys;
import rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain;
import rege.rege.minecraftmod.customsavedirs.text.I18nHelper;

public class CustomSaveDirsScreen
extends Screen {
    public static final int CONFIGURE_SAVE_DIRECTORIES_BUTTON_ID = 123595003;
    public static final int CURRENT_DIR_BUTTON_ID = 923722340;
    public static final int EDIT_FILE_BUTTON_ID = 878847879;
    public static final int LOAD_FILE_BUTTON_ID = 488411916;
    public static final int DONE_BUTTON_ID = 309638920;
    public static final Logger LOGGER = LogManager.getLogger(CustomSaveDirsScreen.class);
    private static @Range(from=0L, to=0x7FFFFFFFL) int CURRENT_DIR = 0;
    public static final TranslatableText TITLE_TEXT = new TranslatableText("options.savedirs.title", new Object[0]);
    public static final TranslatableText EDIT_FILE_TEXT = new TranslatableText("options.savedirs.editfile", new Object[0]);
    public static final TranslatableText LOAD_FILE_TEXT = new TranslatableText("options.savedirs.loadfile", new Object[0]);
    public static final TranslatableText EDIT_FILE_TOOLTIP = new TranslatableText("options.savedirs.editfile.tooltip", new Object[]{FileSystems.getDefault().getPath("config/customsavedirs.json", new String[0]).toAbsolutePath().toString()});
    public static final TranslatableText LOAD_FILE_TOOLTIP = new TranslatableText("options.savedirs.loadfile.tooltip", new Object[0]);
    public static final TranslatableText CURRENT_DIR_TOOLTIP = new TranslatableText("options.savedirs.current.tooltip", new Object[0]);
    public static final TranslatableText CURRENT_UNAVAIL_DIR_TOOLTIP = new TranslatableText("options.savedirs.current.unavailable.tooltip", new Object[0]);
    public final ButtonWidget currentDirButton;
    public final ButtonWidget editFileButton;
    public final ButtonWidget loadFileButton;
    private final Screen parent;

    public static @Range(from=0L, to=0x7FFFFFFFL) int getCurrentDir() {
        return CURRENT_DIR;
    }

    public static @Range(from=0L, to=0x7FFFFFFFL) int setCurrentDir(@Range(from=0L, to=0x7FFFFFFFL) int currentDir) {
        if (currentDir < 0) {
            throw new IllegalArgumentException();
        }
        int RES = CURRENT_DIR;
        CURRENT_DIR = CustomSaveDirsMain.SAVE_DIRS.isEmpty() ? 0 : currentDir % CustomSaveDirsMain.SAVE_DIRS.size();
        return RES;
    }

    public static String textProvider() {
        CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir());
        if (CustomSaveDirsMain.SAVE_DIRS.isEmpty()) {
            return I18nHelper.translateOrFallback("options.savedirs.current", "Current", new Object[0]) + ": " + new TranslatableText("generator.default", new Object[0]).computeValue();
        }
        String DIR_PTH = CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir());
        return (CustomSaveDirsMain.getCachedLevelStorages(DIR_PTH) == null ? I18nHelper.translateOrFallback("options.savedirs.current.unavailable", "Current (unavailable now)", new Object[0]) : I18nHelper.translateOrFallback("options.savedirs.current", "Current", new Object[0])) + ": " + CustomSaveDirsScreen.getCurrentDir() + ": " + DIR_PTH;
    }

    @Nullable
    public static Process openFile(@NotNull String name, @Nullable Logger logger) {
        block15: {
            String osname = System.getProperty("os.name");
            if (osname != null) {
                if ((osname = osname.toLowerCase()).contains("mac")) {
                    try {
                        return Runtime.getRuntime().exec(new String[]{"/usr/bin/open", name});
                    }
                    catch (IOException e) {
                        if (logger != null) {
                            logger.error("Couldn't open file " + name, (Throwable)e);
                        }
                        break block15;
                    }
                }
                if (osname.contains("win") || osname.contains("react")) {
                    try {
                        return Runtime.getRuntime().exec(String.format("cmd.exe /C start \"Open file\" \"%s\"", name));
                    }
                    catch (IOException e) {
                        if (logger != null) {
                            logger.error("Couldn't open file " + name, (Throwable)e);
                        }
                        break block15;
                    }
                }
                if (osname.contains("linux") || osname.contains("bsd")) {
                    try {
                        return Runtime.getRuntime().exec(new String[]{"xdg-open", name});
                    }
                    catch (IOException e) {
                        if (logger == null) break block15;
                        logger.error("Couldn't open file " + name, (Throwable)e);
                    }
                }
            }
        }
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Object desktop = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            clazz.getMethod("open", File.class).invoke(desktop, new File(name));
        }
        catch (Throwable throwable) {
            if (logger != null) {
                LOGGER.error("Couldn't open file", throwable);
                LOGGER.info("Opening via system class!");
            }
            Sys.openURL((String)("file://" + name));
        }
        return null;
    }

    public CustomSaveDirsScreen(Screen parent) {
        this.parent = parent;
        this.currentDirButton = new ButtonWidget(923722340, this.field_22535 / 2 - 155, 40, 310, 20, CustomSaveDirsScreen.textProvider()){

            public void method_21888(SoundManager soundManager) {
                CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir() + 1);
                this.field_22510 = CustomSaveDirsScreen.textProvider();
                CustomSaveDirsScreen.this.method_21947();
                super.method_21888(soundManager);
            }
        };
        this.editFileButton = new ButtonWidget(878847879, this.field_22535 / 2 - 155, 64, 310, 20, I18nHelper.translateOrFallback(EDIT_FILE_TEXT.getKey(), "Edit customsavedirs.json", new Object[0])){

            public void method_21888(SoundManager soundManager) {
                File file = new File("config");
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                if (!(file = new File(file, "customsavedirs.json")).isFile()) {
                    LOGGER.info("config/customsavedirs.json not exist, creating...");
                    try {
                        FileWriter FW = new FileWriter(file);
                        FW.write("[]");
                        FW.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error("cannot create file config/customsavedirs.json", (Throwable)e2);
                    }
                }
                CustomSaveDirsScreen.openFile(new File("config/customsavedirs.json").getAbsolutePath(), LOGGER);
                super.method_21888(soundManager);
            }
        };
        this.loadFileButton = new ButtonWidget(488411916, this.field_22535 / 2 - 155, 88, 310, 20, I18nHelper.translateOrFallback(LOAD_FILE_TEXT.getKey(), "Reload customsavedirs.json", new Object[0])){

            public void method_21888(SoundManager soundManager) {
                CustomSaveDirsMain.loadConfig(new File("config/customsavedirs.json"));
                CustomSaveDirsMain.cleanUpCachedLevelStorages();
                if (CustomSaveDirsScreen.this.field_22534 != null) {
                    CustomSaveDirsMain.createLevelStoragesToCache();
                }
                CustomSaveDirsScreen.this.currentDirButton.field_22510 = CustomSaveDirsScreen.textProvider();
                super.method_21888(soundManager);
            }
        };
    }

    public static void draw(final @NotNull CustomSaveDirsScreen scr) {
        scr.currentDirButton.x = scr.field_22535 / 2 - 155;
        scr.editFileButton.x = scr.field_22535 / 2 - 155;
        scr.loadFileButton.x = scr.field_22535 / 2 - 155;
        scr.field_22537.add(scr.currentDirButton);
        scr.field_22537.add(scr.editFileButton);
        scr.field_22537.add(scr.loadFileButton);
        scr.field_22537.add(new ButtonWidget(309638920, scr.field_22535 / 2 - 100, scr.field_22536 - 27, 200, 20, I18n.translate((String)"gui.done", (Object[])new Object[0])){

            public void method_21888(SoundManager soundManager) {
                if (scr.field_22534 != null) {
                    scr.field_22534.setScreen(scr.parent);
                }
                super.method_21888(soundManager);
            }
        });
    }

    public void method_21947() {
        this.field_22537.clear();
        CustomSaveDirsScreen.draw(this);
    }

    public void method_21925(int mouseX, int mouseY, float delta) {
        this.method_21946();
        if (this.field_22534 != null) {
            this.method_21881(this.field_22534.textRenderer, I18nHelper.translateOrFallback(TITLE_TEXT.getKey(), "Save Directories", new Object[0]), this.field_22535 / 2, 15, 0xFFFFFF);
        }
        super.method_21925(mouseX, mouseY, delta);
        if (this.currentDirButton != null && this.field_22534 != null && this.currentDirButton.method_21885()) {
            if (!CustomSaveDirsMain.SAVE_DIRS.isEmpty() && CustomSaveDirsMain.getCachedLevelStorages(CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir())) == null) {
                this.method_21932(this.field_22534.textRenderer.wrapLines(I18nHelper.translateOrFallback(CURRENT_UNAVAIL_DIR_TOOLTIP.getKey(), "The current directory is unavailable due to an OS-level IO error. Default directory will be used instead.", new Object[0]), 200), mouseX, mouseY);
            } else if (this.field_22534.isIntegratedServerRunning()) {
                this.method_21932(this.field_22534.textRenderer.wrapLines(I18nHelper.translateOrFallback(CURRENT_DIR_TOOLTIP.getKey(), "This option will be applied after you save and exit the current world", new Object[0]), 200), mouseX, mouseY);
            }
        }
        if (this.editFileButton != null && this.field_22534 != null && this.editFileButton.method_21885()) {
            this.method_21932(this.field_22534.textRenderer.wrapLines(I18nHelper.translateOrFallback(EDIT_FILE_TOOLTIP.getKey(), "By clicking this button an editor will open. If not, please manually open %s", FileSystems.getDefault().getPath("config/customsavedirs.json", new String[0]).toAbsolutePath().toString()), 200), mouseX, mouseY);
        }
        if (this.loadFileButton != null && this.field_22534 != null && this.loadFileButton.method_21885()) {
            this.method_21932(this.field_22534.textRenderer.wrapLines(I18nHelper.translateOrFallback(LOAD_FILE_TOOLTIP.getKey(), "The content of customsavedirs.json should be a valid JSON array with zero, one or multiple strings. These strings represent save directories.", new Object[0]), 200), mouseX, mouseY);
        }
    }
}

