/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs.gui.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.text.TranslatableText;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain;
import rege.rege.minecraftmod.customsavedirs.text.I18nHelper;

public class CustomSaveDirsScreen
extends Screen {
    public static final int CONFIGURE_SAVE_DIRECTORIES_BUTTON_ID = 123595003;
    public static final int CURRENT_DIR_BUTTON_ID = 923722340;
    public static final int EDIT_FILE_BUTTON_ID = 878847879;
    public static final int LOAD_FILE_BUTTON_ID = 488411916;
    public static final int DONE_BUTTON_ID = 309638920;
    public static final Logger LOGGER = LogManager.getLogger(CustomSaveDirsScreen.class);
    private static @Range(from=0L, to=0x7FFFFFFFL) int CURRENT_DIR = 0;
    public static final TranslatableText TITLE_TEXT = new TranslatableText("options.savedirs.title", new Object[0]);
    public static final TranslatableText EDIT_FILE_TEXT = new TranslatableText("options.savedirs.editfile", new Object[0]);
    public static final TranslatableText LOAD_FILE_TEXT = new TranslatableText("options.savedirs.loadfile", new Object[0]);
    public static final TranslatableText EDIT_FILE_TOOLTIP = new TranslatableText("options.savedirs.editfile.tooltip", new Object[]{FileSystems.getDefault().getPath("config/customsavedirs.json", new String[0]).toAbsolutePath().toString()});
    public static final TranslatableText LOAD_FILE_TOOLTIP = new TranslatableText("options.savedirs.loadfile.tooltip", new Object[0]);
    public static final TranslatableText CURRENT_DIR_TOOLTIP = new TranslatableText("options.savedirs.current.tooltip", new Object[0]);
    public static final TranslatableText CURRENT_UNAVAIL_DIR_TOOLTIP = new TranslatableText("options.savedirs.current.unavailable.tooltip", new Object[0]);
    public final ButtonWidget currentDirButton;
    public final ButtonWidget editFileButton;
    public final ButtonWidget loadFileButton;
    private final Screen parent;

    @Contract(pure=true)
    public static @Range(from=0L, to=0x7FFFFFFFL) int getCurrentDir() {
        return CURRENT_DIR;
    }

    public static @Range(from=0L, to=0x7FFFFFFFL) int setCurrentDir(@Range(from=0L, to=0x7FFFFFFFL) int currentDir) {
        if (currentDir < 0) {
            throw new IllegalArgumentException();
        }
        int RES = CURRENT_DIR;
        CURRENT_DIR = CustomSaveDirsMain.SAVE_DIRS.isEmpty() ? 0 : currentDir % CustomSaveDirsMain.SAVE_DIRS.size();
        return RES;
    }

    public static String textProvider() {
        CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir());
        if (CustomSaveDirsMain.SAVE_DIRS.isEmpty()) {
            return I18nHelper.translateOrFallback("options.savedirs.current", "Current", new Object[0]) + ": " + new TranslatableText("generator.default", new Object[0]).computeValue();
        }
        String DIR_PTH = CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir());
        return (CustomSaveDirsMain.getCachedLevelStorages(DIR_PTH) == null ? I18nHelper.translateOrFallback("options.savedirs.current.unavailable", "Current (unavailable now)", new Object[0]) : I18nHelper.translateOrFallback("options.savedirs.current", "Current", new Object[0])) + ": " + CustomSaveDirsScreen.getCurrentDir() + ": " + DIR_PTH;
    }

    public CustomSaveDirsScreen(Screen parent) {
        this.parent = parent;
        this.currentDirButton = new ButtonWidget(923722340, this.width / 2 - 155, 40, 310, 20, CustomSaveDirsScreen.textProvider()){

            public void method_18374(double d, double e) {
                CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir() + 1);
                this.message = CustomSaveDirsScreen.textProvider();
                CustomSaveDirsScreen.this.init();
            }
        };
        this.editFileButton = new ButtonWidget(878847879, this.width / 2 - 155, 64, 310, 20, I18nHelper.translateOrFallback(EDIT_FILE_TEXT.getKey(), "Edit customsavedirs.json", new Object[0])){

            public void method_18374(double d, double e) {
                File file = new File("config");
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                if (!(file = new File(file, "customsavedirs.json")).isFile()) {
                    LOGGER.info("config/customsavedirs.json not exist, creating...");
                    try {
                        FileWriter FW = new FileWriter(file);
                        FW.write("[]");
                        FW.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error("cannot create file config/customsavedirs.json", (Throwable)e2);
                    }
                }
                Util.getOperatingSystem().method_20235(new File("config/customsavedirs.json"));
            }
        };
        this.loadFileButton = new ButtonWidget(488411916, this.width / 2 - 155, 88, 310, 20, I18nHelper.translateOrFallback(LOAD_FILE_TEXT.getKey(), "Reload customsavedirs.json", new Object[0])){

            public void method_18374(double d, double e) {
                CustomSaveDirsMain.loadConfig(new File("config/customsavedirs.json"));
                CustomSaveDirsMain.cleanUpCachedLevelStorages();
                if (CustomSaveDirsScreen.this.client != null) {
                    CustomSaveDirsMain.createLevelStoragesToCache(CustomSaveDirsScreen.this.client.getCurrentSave());
                }
                CustomSaveDirsScreen.this.currentDirButton.message = CustomSaveDirsScreen.textProvider();
            }
        };
    }

    public static void draw(final @NotNull CustomSaveDirsScreen scr) {
        scr.currentDirButton.x = scr.width / 2 - 155;
        scr.editFileButton.x = scr.width / 2 - 155;
        scr.loadFileButton.x = scr.width / 2 - 155;
        scr.addButton(scr.currentDirButton);
        scr.addButton(scr.editFileButton);
        scr.addButton(scr.loadFileButton);
        scr.addButton(new ButtonWidget(309638920, scr.width / 2 - 100, scr.height - 27, 200, 20, I18n.translate((String)"gui.done", (Object[])new Object[0])){

            public void method_18374(double d, double e) {
                if (scr.client != null) {
                    scr.client.setScreen(scr.parent);
                }
            }
        });
    }

    protected void init() {
        this.buttons.clear();
        this.field_20307.clear();
        CustomSaveDirsScreen.draw(this);
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.renderBackground();
        if (this.client != null) {
            this.drawCenteredString(this.client.textRenderer, I18nHelper.translateOrFallback(TITLE_TEXT.getKey(), "Save Directories", new Object[0]), this.width / 2, 15, 0xFFFFFF);
        }
        super.render(mouseX, mouseY, delta);
        if (this.currentDirButton != null && this.client != null && this.currentDirButton.isHovered()) {
            if (!CustomSaveDirsMain.SAVE_DIRS.isEmpty() && CustomSaveDirsMain.getCachedLevelStorages(CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir())) == null) {
                this.renderTooltip(this.client.textRenderer.wrapLines(I18nHelper.translateOrFallback(CURRENT_UNAVAIL_DIR_TOOLTIP.getKey(), "The current directory is unavailable due to an OS-level IO error. Default directory will be used instead.", new Object[0]), 200), mouseX, mouseY);
            } else if (this.client.isIntegratedServerRunning()) {
                this.renderTooltip(this.client.textRenderer.wrapLines(I18nHelper.translateOrFallback(CURRENT_DIR_TOOLTIP.getKey(), "This option will be applied after you save and exit the current world", new Object[0]), 200), mouseX, mouseY);
            }
        }
        if (this.editFileButton != null && this.client != null && this.editFileButton.isHovered()) {
            this.renderTooltip(this.client.textRenderer.wrapLines(I18nHelper.translateOrFallback(EDIT_FILE_TOOLTIP.getKey(), "By clicking this button an editor will open. If not, please manually open %s", FileSystems.getDefault().getPath("config/customsavedirs.json", new String[0]).toAbsolutePath().toString()), 200), mouseX, mouseY);
        }
        if (this.loadFileButton != null && this.client != null && this.loadFileButton.isHovered()) {
            this.renderTooltip(this.client.textRenderer.wrapLines(I18nHelper.translateOrFallback(LOAD_FILE_TOOLTIP.getKey(), "The content of customsavedirs.json should be a valid JSON array with zero, one or multiple strings. These strings represent save directories.", new Object[0]), 200), mouseX, mouseY);
        }
    }
}

