package rege.rege.minecraftmod.customsavedirs.gui.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import net.minecraft.class_1664;
import net.minecraft.class_1723;
import net.minecraft.class_1990;
import net.minecraft.class_356;
import net.minecraft.class_388;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

import static org.apache.logging.log4j.LogManager.getLogger;
import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain.*;
import static rege.rege.minecraftmod.customsavedirs.text.I18nHelper.translateOrFallback;

public class CustomSaveDirsScreen extends class_388 {
    public static final int CONFIGURE_SAVE_DIRECTORIES_BUTTON_ID = 123595003;
    public static final int CURRENT_DIR_BUTTON_ID = 923722340;
    public static final int EDIT_FILE_BUTTON_ID = 878847879;
    public static final int LOAD_FILE_BUTTON_ID = 488411916;
    public static final int DONE_BUTTON_ID = 309638920;
    public static final Logger LOGGER = getLogger(CustomSaveDirsScreen.class);
    private static @Range(from = 0, to = Integer.MAX_VALUE) int CURRENT_DIR =0;
    public static final class_1990 TITLE_TEXT =
    new class_1990("options.savedirs.title");
    public static final class_1990 EDIT_FILE_TEXT =
    new class_1990("options.savedirs.editfile");
    public static final class_1990 LOAD_FILE_TEXT =
    new class_1990("options.savedirs.loadfile");
    public static final class_1990 EDIT_FILE_TOOLTIP =
    new class_1990("options.savedirs.editfile.tooltip",
                         FileSystems.getDefault().getPath(
        "config/customsavedirs.json"
    ).toAbsolutePath().toString());
    public static final class_1990 LOAD_FILE_TOOLTIP =
    new class_1990("options.savedirs.loadfile.tooltip");
    public static final class_1990 CURRENT_DIR_TOOLTIP =
    new class_1990("options.savedirs.current.tooltip");
    public static final class_1990 CURRENT_UNAVAIL_DIR_TOOLTIP =
    new class_1990("options.savedirs.current.unavailable.tooltip");

    @Contract(pure = true)
    public static @Range(from = 0, to = Integer.MAX_VALUE) int getCurrentDir(){
        return CURRENT_DIR;
    }

    public static @Range(from = 0, to = Integer.MAX_VALUE) int
    setCurrentDir(@Range(from = 0, to = Integer.MAX_VALUE) int currentDir) {
        if (currentDir < 0) {
            throw new IllegalArgumentException();
        }
        final int RES = CURRENT_DIR;
        CURRENT_DIR = SAVE_DIRS.isEmpty() ? 0 :(currentDir % SAVE_DIRS.size());
        return RES;
    }

    public static String textProvider() {
        setCurrentDir(getCurrentDir());
        if (SAVE_DIRS.isEmpty()) {
            return translateOrFallback(
                "options.savedirs.current", "Current"
            ) + ": " +new class_1990("generator.default").method_7473();
        }
        final String DIR_PTH = SAVE_DIRS.get(getCurrentDir());
        return ((getCachedLevelStorages(DIR_PTH) == null) ?
                translateOrFallback(
            "options.savedirs.current.unavailable", "Current (unavailable now)"
        ) : translateOrFallback(
            "options.savedirs.current", "Current"
        )) + ": " + getCurrentDir() + ": " + DIR_PTH;
    }

    public final class_356 currentDirButton;
    public final class_356 editFileButton;
    public final class_356 loadFileButton;
    private final class_388 parent;

    public CustomSaveDirsScreen(class_388 parent) {
        super();
        this.parent = parent;
        this.currentDirButton = new class_356(
            CURRENT_DIR_BUTTON_ID, this.field_1230 / 2 - 155, 40, 310, 20,
            textProvider()
        ) {
            @Override
            public void method_18374(double d, double e) {
                setCurrentDir(getCurrentDir() + 1);
                this.field_1053 = textProvider();
                CustomSaveDirsScreen.this.method_1044();
            }
        };
        this.editFileButton = new class_356(
            EDIT_FILE_BUTTON_ID, this.field_1230 / 2 - 155, 64, 310, 20,
            translateOrFallback(
                EDIT_FILE_TEXT.method_7531(), "Edit customsavedirs.json"
            )
        ) {
            @Override
            public void method_18374(double d, double e) {
                File file = new File("config");
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                file = new File(file, "customsavedirs.json");
                if (!file.isFile()) {
                    LOGGER.info(
                        "config/customsavedirs.json not exist, creating..."
                    );
                    try {
                        final FileWriter FW = new FileWriter(file);
                        FW.write("[]");
                        FW.close();
                    } catch (IOException e2) {
                        LOGGER.error(
                            "cannot create file config/customsavedirs.json", e2
                        );
                    }
                }
                class_1723.method_6318().method_20235(new File(
                    "config/customsavedirs.json"
                ));
            }
        };
        this.loadFileButton = new class_356(
            LOAD_FILE_BUTTON_ID, this.field_1230 / 2 - 155, 88, 310, 20,
            translateOrFallback(
                LOAD_FILE_TEXT.method_7531(), "Reload customsavedirs.json"
            )
        ) {
            @Override
            public void method_18374(double d, double e) {
                loadConfig(new File("config/customsavedirs.json"));
                cleanUpCachedLevelStorages();
                if (CustomSaveDirsScreen.this.field_1229 != null) {
                    createLevelStoragesToCache(
                        CustomSaveDirsScreen.this.field_1229.method_2944()
                    );
                }
                CustomSaveDirsScreen.this.currentDirButton.field_1053 =
                textProvider();
            }
        };
    }

    public static void draw(@NotNull CustomSaveDirsScreen scr) {
        scr.currentDirButton.field_1051 = scr.field_1230 / 2 - 155;
        scr.editFileButton.field_1051 = scr.field_1230 / 2 - 155;
        scr.loadFileButton.field_1051 = scr.field_1230 / 2 - 155;
        scr.method_13411(scr.currentDirButton);
        scr.method_13411(scr.editFileButton);
        scr.method_13411(scr.loadFileButton);
        scr.method_13411(new class_356(
            DONE_BUTTON_ID, scr.field_1230 / 2 - 100, scr.field_1231 - 27, 200, 20,
            class_1664.method_5934("gui.done")
        ) {
            @Override
            public void method_18374(double d, double e) {
                if (scr.field_1229 != null) {
                    scr.field_1229.method_2928(scr.parent);
                }
            }
        });
    }

    @Override
    protected void method_1044() {
        this.field_1232.clear();
        this.field_20307.clear();
        CustomSaveDirsScreen.draw(this);
    }

    @Override
    public void method_1025(int mouseX, int mouseY, float delta) {
        this.method_1043();
        if (this.field_1229 != null) {
            this.method_990(
                this.field_1229.field_3814,
                translateOrFallback(TITLE_TEXT.method_7531(), "Save Directories"),
                this.field_1230 / 2, 15, 16777215
            );
        }
        super.method_1025(mouseX, mouseY, delta);
        if (this.currentDirButton != null && this.field_1229 != null &&
            this.currentDirButton.method_4229()) {
            if ((!SAVE_DIRS.isEmpty()) &&
                getCachedLevelStorages(SAVE_DIRS.get(getCurrentDir()))==null) {
                this.method_6754(this.field_1229.field_3814.method_971(
                    translateOrFallback(
                        CURRENT_UNAVAIL_DIR_TOOLTIP.method_7531(),
                        "The current directory is unavailable due to an OS-level IO error. Default directory will be used instead."
                    ), 200
                ), mouseX, mouseY);
            } else if (this.field_1229.method_2907()) {
                this.method_6754(this.field_1229.field_3814.method_971(
                    translateOrFallback(
                        CURRENT_DIR_TOOLTIP.method_7531(),
                        "This option will be applied after you save and exit the current world"
                    ), 200
                ), mouseX, mouseY);
            }
        }
        if (this.editFileButton != null && this.field_1229 != null &&
            this.editFileButton.method_4229()) {
            this.method_6754(this.field_1229.field_3814.method_971(
                translateOrFallback(
                    EDIT_FILE_TOOLTIP.method_7531(),
                    "By clicking this button an editor will open. If not, please manually open %s",
                    FileSystems.getDefault().getPath(
                        "config/customsavedirs.json"
                    ).toAbsolutePath().toString()
                ), 200
            ), mouseX, mouseY);
        }
        if (this.loadFileButton != null && this.field_1229 != null &&
            this.loadFileButton.method_4229()) {
            this.method_6754(this.field_1229.field_3814.method_971(
                translateOrFallback(
                    LOAD_FILE_TOOLTIP.method_7531(),
                    "The content of customsavedirs.json should be a valid JSON array with zero, one or multiple strings. These strings represent save directories."
                ), 200
            ), mouseX, mouseY);
        }
    }
}
