package rege.rege.minecraftmod.customsavedirs.mixin;

import java.io.File;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain
              .SAVE_DIRS;
import static rege.rege.minecraftmod.customsavedirs.gui.screen
              .CustomSaveDirsScreen.getCurrentDir;
import static rege.rege.minecraftmod.customsavedirs.gui.screen
              .CustomSaveDirsScreen.setCurrentDir;

@Mixin(net.minecraft.class_601.class)
public abstract class IntegratedServerMixin {
    @ModifyArg(method = "<init>", at = @At(
        value = "INVOKE",
        target =
        "Lnet/minecraft/server/MinecraftServer;<init>(Ljava/io/File;Ljava/net/Proxy;Lcom/mojang/datafixers/DataFixer;Lnet/minecraft/server/command/CommandManager;Lcom/mojang/authlib/yggdrasil/YggdrasilAuthenticationService;Lcom/mojang/authlib/minecraft/MinecraftSessionService;Lcom/mojang/authlib/GameProfileRepository;Lnet/minecraft/util/UserCache;)V",
        ordinal = 0
    ), index = 0)
    private static File injected(File file) {
        if (!SAVE_DIRS.isEmpty()) {
            if (getCurrentDir() >= SAVE_DIRS.size()) {
                setCurrentDir(SAVE_DIRS.size() - 1);
            }
            return new File(SAVE_DIRS.get(getCurrentDir()));
        }
        return file;
    }
}
