package rege.rege.minecraftmod.customsavedirs.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain
              .SAVE_DIRS;
import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain
              .createLevelStoragesToCache;
import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain
              .getCachedLevelStorages;
import static rege.rege.minecraftmod.customsavedirs.gui.screen
              .CustomSaveDirsScreen.getCurrentDir;
import static rege.rege.minecraftmod.customsavedirs.gui.screen
              .CustomSaveDirsScreen.setCurrentDir;

import net.minecraft.class_102;

@Mixin(net.minecraft.class_1600.class)
public abstract class ModifyDefaultSaveDirMixin {
    @Shadow
    public abstract class_102 getCurrentSave();

    @Inject(method = "initializeGame", at = @At("RETURN"))
    private void cacheStorages(CallbackInfo info) {
        createLevelStoragesToCache(this.getCurrentSave());
    }

    @Inject(method = "getCurrentSave", at = @At("RETURN"), cancellable = true)
    private void
    injectGetLevelStorage(CallbackInfoReturnable<class_102> info) {
        if (!SAVE_DIRS.isEmpty()) {
            if (getCurrentDir() >= SAVE_DIRS.size()) {
                setCurrentDir(SAVE_DIRS.size() - 1);
            }
            final class_102 LS = getCachedLevelStorages(SAVE_DIRS.get(
                getCurrentDir()
            ));
            if (LS != null) {
                info.setReturnValue(LS);
            } else {
                System.err.println("cached level storage is null!");
            }
        }
    }
}
