/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs.mixin;

import java.io.File;
import java.io.IOError;
import java.nio.file.InvalidPathException;
import java.util.IdentityHashMap;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.world.SelectWorldScreen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.client.sound.SoundManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain;
import rege.rege.minecraftmod.customsavedirs.SearchWorldEnhanceFunctions;
import rege.rege.minecraftmod.customsavedirs.text.I18nHelper;

@Mixin(value={SelectWorldScreen.class})
public abstract class DirectOpenWorldMixin
extends Screen {
    private static final IdentityHashMap<Screen, ButtonWidget> BUTTONS = new IdentityHashMap();

    @Contract(value="_, _ -> new")
    private static ButtonWidget createBackButton(final @NotNull Screen screen, final @NotNull MinecraftClient client) {
        return new ButtonWidget(223886224, screen.width / 2 - 50, screen.height / 2, 100, 20, I18n.translate((String)"gui.back", (Object[])new Object[0])){

            public void playDownSound(SoundManager soundManager) {
                super.playDownSound(soundManager);
                client.setScreen(screen);
            }
        };
    }

    @Contract(value="_, _ -> new")
    private static Screen createErrorScreen(final Screen parent, final @NotNull String e) {
        return new Screen(){

            public void init() {
                this.buttons.clear();
                this.buttons.add(DirectOpenWorldMixin.createBackButton(parent, this.client));
            }

            public void render(int mouseX, int mouseY, float delta) {
                this.renderBackground();
                if (this.client != null) {
                    int h = 20;
                    this.drawCenteredString(this.client.textRenderer, "CustomSaveDirs - Error", this.width / 2, h - 5, 0xFFFFFF);
                    for (Object i : this.client.textRenderer.wrapLines(e, this.width)) {
                        h += 10;
                        if (!(i instanceof String)) continue;
                        this.drawCenteredString(this.client.textRenderer, (String)i, this.width / 2, h, 0xFFFFFF);
                    }
                }
                super.render(mouseX, mouseY, delta);
            }
        };
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void cleanDirectStorage(CallbackInfo info) {
        if (this.client != null) {
            CustomSaveDirsMain.setDirectStorage(this.client, null);
        }
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void createOpenButton(CallbackInfo info) {
        try {
            SearchWorldEnhanceFunctions.init();
        }
        catch (NoClassDefFoundError ignored) {
            return;
        }
        Integer Y = SearchWorldEnhanceFunctions.getSearchBoxY((SelectWorldScreen)this);
        ButtonWidget BUTTON = new ButtonWidget(123876326, this.width / 2 + 100, Y == null ? 11 : Y, 80, 20, I18nHelper.translateOrFallback("customsavedirs.open_path", "Open This Path", new Object[0])){

            public void playDownSound(SoundManager soundManager) {
                try {
                    if (DirectOpenWorldMixin.this.client != null) {
                        String STR = SearchWorldEnhanceFunctions.getSearchBoxString((SelectWorldScreen)DirectOpenWorldMixin.this);
                        if (STR != null) {
                            CustomSaveDirsMain.setDirectStorage(DirectOpenWorldMixin.this.client, new File(STR));
                        }
                        DirectOpenWorldMixin.this.client.startIntegratedServer("", "", null);
                    }
                }
                catch (InvalidPathException e) {
                    CustomSaveDirsMain.LOGGER.warn("Unable to open world with the path", (Throwable)e);
                }
                catch (IOError | NullPointerException e) {
                    if (e instanceof IOError) {
                        CustomSaveDirsMain.LOGGER.error("Unable to open world with the path", e);
                    } else {
                        CustomSaveDirsMain.LOGGER.warn("Unable to open world with the path. Is the path a world?", e);
                    }
                    DirectOpenWorldMixin.this.client.setScreen(DirectOpenWorldMixin.createErrorScreen(DirectOpenWorldMixin.this, e.toString()));
                }
            }
        };
        this.buttons.add(BUTTON);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void renderTooltip(int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (BUTTONS.get((Object)this) != null && this.client != null && BUTTONS.get((Object)this).isHovered()) {
            this.renderTooltip(this.client.textRenderer.wrapLines(I18nHelper.translateOrFallback("customsavedirs.open_path.tooltip", "Input the full path(relative or absolute) of the world's directory and click this button to open it directly", new Object[0]), 200), mouseX, mouseY);
        }
    }
}

