/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSaveDirsMain
implements ClientModInitializer {
    public static final ArrayList<String> SAVE_DIRS = new ArrayList();
    private static final HashMap<String, class_32> CACHED_LEVEL_STORAGES = new HashMap();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)CustomSaveDirsMain.class.getName());
    public static final class_5250 CONFIGURE_SAVE_DIRECTORIES_TEXT = class_2561.method_48321((String)"options.savedirs", (String)"Configure Save Directories...");

    @Nullable
    public static RuntimeException validate(@NotNull String path) {
        try {
            Path.of(path, new String[0]);
        }
        catch (RuntimeException e) {
            return e;
        }
        return null;
    }

    public static void createLevelStoragesToCache(@NotNull class_32 builtin) {
        for (String i : SAVE_DIRS) {
            CACHED_LEVEL_STORAGES.put(i, new class_32(Path.of(i, new String[0]), builtin.method_236(), builtin.method_52237(), class_310.method_1551().method_1543()));
        }
    }

    public static void cleanUpCachedLevelStorages() {
        for (String i : new HashSet<String>(CACHED_LEVEL_STORAGES.keySet())) {
            if (SAVE_DIRS.contains(i)) continue;
            CACHED_LEVEL_STORAGES.remove(i);
        }
    }

    @Contract(pure=true)
    @Nullable
    public static class_32 getCachedLevelStorages(@NotNull String path) {
        return CACHED_LEVEL_STORAGES.get(path);
    }

    public static void loadConfig(@NotNull File configFile) {
        if (configFile.isFile()) {
            try {
                int ach;
                FileReader FR = new FileReader(configFile);
                StringBuilder SB = new StringBuilder();
                while ((ach = FR.read()) != -1) {
                    SB.append((char)ach);
                }
                FR.close();
                JsonElement JE = JsonParser.parseString((String)SB.toString());
                SAVE_DIRS.clear();
                if (JE.isJsonArray()) {
                    for (JsonElement jsonElement : JE.getAsJsonArray()) {
                        String STR = jsonElement.getAsString();
                        RuntimeException VALIDATION = CustomSaveDirsMain.validate(STR);
                        if (VALIDATION == null) {
                            SAVE_DIRS.add(jsonElement.getAsString());
                            continue;
                        }
                        LOGGER.warn("Will not load directory " + STR, (Throwable)VALIDATION);
                    }
                }
                LOGGER.info("Loaded these directories from config/customsavedirs.json:");
                for (String string : SAVE_DIRS) {
                    LOGGER.info(string);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read file config/customsavedirs.json");
            }
            catch (RuntimeException e) {
                LOGGER.error("Error loading config/customsavedirs.json", (Throwable)e);
            }
        } else {
            LOGGER.info("Normal file config/customsavedirs.json not found.");
            LOGGER.info("Now use default save directory.");
        }
    }

    public void onInitializeClient() {
    }

    static {
        CustomSaveDirsMain.loadConfig(new File("config/customsavedirs.json"));
        CustomSaveDirsMain.cleanUpCachedLevelStorages();
    }
}

