/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.client.MinecraftClient;
import net.minecraft.text.MutableText;
import net.minecraft.text.Text;
import net.minecraft.world.level.storage.LevelStorage;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomSaveDirsMain
implements ClientModInitializer {
    public static final ArrayList<String> SAVE_DIRS = new ArrayList();
    private static final HashMap<String, LevelStorage> CACHED_LEVEL_STORAGES = new HashMap();
    public static final Logger LOGGER = LoggerFactory.getLogger(CustomSaveDirsMain.class);
    public static final MutableText CONFIGURE_SAVE_DIRECTORIES_TEXT = Text.translatable((String)"options.savedirs");

    @Contract(pure=true)
    @Nullable
    public static RuntimeException validate(@NotNull String path) {
        try {
            Path.of(path, new String[0]);
        }
        catch (RuntimeException e) {
            return e;
        }
        return null;
    }

    public static void createLevelStoragesToCache(@NotNull LevelStorage builtin) {
        for (String i : SAVE_DIRS) {
            try {
                CACHED_LEVEL_STORAGES.put(i, new LevelStorage(Path.of(i, new String[0]), builtin.getBackupsDirectory(), MinecraftClient.getInstance().getDataFixer()));
            }
            catch (IOError e) {
                LOGGER.error("Unable to cache level storage of " + i + " due to an OS-level IO error", (Throwable)e);
            }
        }
    }

    public static void cleanUpCachedLevelStorages() {
        for (String i : new HashSet<String>(CACHED_LEVEL_STORAGES.keySet())) {
            if (SAVE_DIRS.contains(i)) continue;
            CACHED_LEVEL_STORAGES.remove(i);
        }
    }

    @Contract(pure=true)
    @Nullable
    public static LevelStorage getCachedLevelStorages(@NotNull String path) {
        return CACHED_LEVEL_STORAGES.get(path);
    }

    public static void loadConfig(@NotNull File configFile) {
        if (configFile.isFile()) {
            try {
                int ach;
                FileReader FR = new FileReader(configFile);
                StringBuilder SB = new StringBuilder();
                while ((ach = FR.read()) != -1) {
                    SB.append((char)ach);
                }
                FR.close();
                JsonElement JE = JsonParser.parseString((String)SB.toString());
                SAVE_DIRS.clear();
                if (JE.isJsonArray()) {
                    for (JsonElement jsonElement : JE.getAsJsonArray()) {
                        String STR = jsonElement.getAsString();
                        RuntimeException VALIDATION = CustomSaveDirsMain.validate(STR);
                        if (VALIDATION == null) {
                            SAVE_DIRS.add(jsonElement.getAsString());
                            continue;
                        }
                        LOGGER.warn("Will not load directory " + STR, (Throwable)VALIDATION);
                    }
                }
                LOGGER.info("Loaded these directories from config/customsavedirs.json:");
                for (String string : SAVE_DIRS) {
                    LOGGER.info(string);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to read file config/customsavedirs.json");
            }
            catch (RuntimeException e) {
                LOGGER.error("Error loading config/customsavedirs.json", (Throwable)e);
            }
        } else {
            LOGGER.info("Normal file config/customsavedirs.json not found.");
            LOGGER.info("Now use default save directory.");
        }
    }

    @Contract(pure=true)
    public void onInitializeClient() {
    }

    static {
        CustomSaveDirsMain.loadConfig(new File("config/customsavedirs.json"));
        CustomSaveDirsMain.cleanUpCachedLevelStorages();
    }
}

