package rege.rege.minecraftmod.customsavedirs.mixin;

import java.net.URL;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(net.minecraft.class_156.class_158.class)
public abstract class UtilBugFixMixin {
    @Inject(method = "getURLOpenCommand", at = @At("RETURN"))
    private void inject(URL url, CallbackInfoReturnable<String[]> info) {
        final String[] RES = info.getReturnValue();
        final int MI = RES.length - 1;
        if (RES[MI].startsWith("file:////")) {
            int chi = 9;
            while (RES[MI].charAt(chi) == '/') {
                chi++;
            }
            RES[MI] = "file:///" + RES[MI].substring(chi);
        }
    }
}
