/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs.gui.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.MinecraftClient;
import net.minecraft.client.gui.DrawContext;
import net.minecraft.client.gui.Element;
import net.minecraft.client.gui.ScreenRect;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.tooltip.Tooltip;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.gui.widget.ClickableWidget;
import net.minecraft.client.gui.widget.DirectionalLayoutWidget;
import net.minecraft.client.gui.widget.SimplePositioningWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.screen.ScreenTexts;
import net.minecraft.text.MutableText;
import net.minecraft.text.Text;
import net.minecraft.util.Util;
import org.jetbrains.annotations.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain;

public class CustomSaveDirsScreen
extends Screen {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)CustomSaveDirsScreen.class.getName());
    private static @Range(from=0L, to=0x7FFFFFFFL) int CURRENT_DIR = 0;
    public static final MutableText TITLE_TEXT = Text.translatableWithFallback((String)"options.savedirs.title", (String)"Save Directories");
    public static final MutableText EDIT_FILE_TEXT = Text.translatableWithFallback((String)"options.savedirs.editfile", (String)"Edit customsavedirs.json");
    public static final MutableText LOAD_FILE_TEXT = Text.translatableWithFallback((String)"options.savedirs.loadfile", (String)"Reload customsavedirs.json");
    public static final MutableText EDIT_FILE_TOOLTIP = Text.translatableWithFallback((String)"options.savedirs.editfile.tooltip", (String)"By clicking this button an editor will open. If not, please manually open %s", (Object[])new Object[]{Path.of("config/customsavedirs.json", new String[0]).toAbsolutePath().toString()});
    public static final MutableText LOAD_FILE_TOOLTIP = Text.translatableWithFallback((String)"options.savedirs.loadfile.tooltip", (String)"The content of customsavedirs.json should be a valid JSON array with zero, one or multiple strings. These strings represent save directories.");
    public static final MutableText CURRENT_DIR_TOOLTIP = Text.translatableWithFallback((String)"options.savedirs.current.tooltip", (String)"This option will be applied after you save and exit the current world");
    public static final MutableText CURRENT_UNAVAIL_DIR_TOOLTIP = Text.translatableWithFallback((String)"options.savedirs.current.unavailable.tooltip", (String)"The current directory is unavailable due to an OS-level IO error. Default directory will be used instead.");
    public final DirectionalLayoutWidget layout2 = DirectionalLayoutWidget.vertical().spacing(5);
    public final ButtonWidget currentDirButton;
    public final ButtonWidget editFileButton;
    public final ButtonWidget loadFileButton;
    private final Screen parent;

    public static @Range(from=0L, to=0x7FFFFFFFL) int getCurrentDir() {
        return CURRENT_DIR;
    }

    public static @Range(from=0L, to=0x7FFFFFFFL) int setCurrentDir(@Range(from=0L, to=0x7FFFFFFFL) int currentDir) {
        if (currentDir < 0) {
            throw new IllegalArgumentException();
        }
        int RES = CURRENT_DIR;
        CURRENT_DIR = CustomSaveDirsMain.SAVE_DIRS.isEmpty() ? 0 : currentDir % CustomSaveDirsMain.SAVE_DIRS.size();
        return RES;
    }

    public static Text textProvider() {
        CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir());
        if (CustomSaveDirsMain.SAVE_DIRS.isEmpty()) {
            return Text.translatableWithFallback((String)"options.savedirs.current", (String)"Current").append((Text)Text.literal((String)": ")).append((Text)Text.translatable((String)"options.gamma.default"));
        }
        String DIR_PTH = CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir());
        return (CustomSaveDirsMain.getCachedLevelStorages(DIR_PTH) == null ? Text.translatableWithFallback((String)"options.savedirs.current.unavailable", (String)"Current (unavailable now)") : Text.translatableWithFallback((String)"options.savedirs.current", (String)"Current")).append((Text)Text.literal((String)": ")).append((Text)Text.literal((String)(CustomSaveDirsScreen.getCurrentDir() + ": " + DIR_PTH)));
    }

    public CustomSaveDirsScreen(Screen parent) {
        super((Text)TITLE_TEXT);
        this.parent = parent;
        ButtonWidget.Builder bwb = ButtonWidget.builder((Text)CustomSaveDirsScreen.textProvider(), button -> {
            CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir() + 1);
            this.init();
            button.setMessage(CustomSaveDirsScreen.textProvider());
            if (!CustomSaveDirsMain.SAVE_DIRS.isEmpty() && CustomSaveDirsMain.getCachedLevelStorages(CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir())) == null) {
                button.setTooltip(Tooltip.of((Text)CURRENT_UNAVAIL_DIR_TOOLTIP));
            } else if (MinecraftClient.getInstance().isIntegratedServerRunning()) {
                button.setTooltip(Tooltip.of((Text)CURRENT_DIR_TOOLTIP));
            } else {
                button.setTooltip(null);
            }
        }).dimensions(this.width / 2 - 155, 40, 310, 20);
        if (!CustomSaveDirsMain.SAVE_DIRS.isEmpty() && CustomSaveDirsMain.getCachedLevelStorages(CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir())) == null) {
            bwb = bwb.tooltip(Tooltip.of((Text)CURRENT_UNAVAIL_DIR_TOOLTIP));
        } else if (MinecraftClient.getInstance().isIntegratedServerRunning()) {
            bwb = bwb.tooltip(Tooltip.of((Text)CURRENT_DIR_TOOLTIP));
        }
        this.currentDirButton = bwb.build();
        this.layout2.add((Widget)this.currentDirButton);
        this.editFileButton = ButtonWidget.builder((Text)EDIT_FILE_TEXT, button -> {
            File file = new File("config");
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            if (!(file = new File(file, "customsavedirs.json")).isFile()) {
                LOGGER.info("config/customsavedirs.json not exist, creating...");
                try {
                    FileWriter FW = new FileWriter(file);
                    FW.write("[]");
                    FW.close();
                }
                catch (IOException e) {
                    LOGGER.error("cannot create file config/customsavedirs.json", (Throwable)e);
                }
            }
            Util.getOperatingSystem().open(new File("config/customsavedirs.json"));
        }).width(310).tooltip(Tooltip.of((Text)EDIT_FILE_TOOLTIP)).build();
        this.layout2.add((Widget)this.editFileButton);
        this.loadFileButton = ButtonWidget.builder((Text)LOAD_FILE_TEXT, button -> {
            CustomSaveDirsMain.loadConfig(new File("config/customsavedirs.json"));
            CustomSaveDirsMain.cleanUpCachedLevelStorages();
            if (this.client != null) {
                CustomSaveDirsMain.createLevelStoragesToCache(this.client.getLevelStorage());
            }
            this.currentDirButton.setMessage(CustomSaveDirsScreen.textProvider());
        }).width(310).tooltip(Tooltip.of((Text)LOAD_FILE_TOOLTIP)).build();
        this.layout2.add((Widget)this.loadFileButton);
    }

    public static void draw(CustomSaveDirsScreen scr) {
        scr.layout2.getMainPositioner().alignHorizontalCenter().margin(10);
        scr.layout2.refreshPositions();
        scr.layout2.forEachChild(x$0 -> {
            ClickableWidget cfr_ignored_0 = (ClickableWidget)scr.addDrawableChild((Element)x$0);
        });
        scr.addDrawableChild((Element)ButtonWidget.builder((Text)ScreenTexts.DONE, button -> {
            if (scr.client != null) {
                scr.client.setScreen(scr.parent);
            }
        }).dimensions(scr.width / 2 - 100, scr.height - 27, 200, 20).build());
    }

    protected void init() {
        CustomSaveDirsScreen.draw(this);
        this.initTabNavigation();
    }

    protected void initTabNavigation() {
        this.clearChildren();
        CustomSaveDirsScreen.draw(this);
        this.layout2.refreshPositions();
        SimplePositioningWidget.setPos((Widget)this.layout2, (ScreenRect)this.getNavigationFocus());
    }

    public void render(DrawContext context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.drawCenteredTextWithShadow(this.textRenderer, this.title, this.width / 2, 15, 0xFFFFFF);
    }
}

