/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs.gui.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.font.TextRenderer;
import net.minecraft.client.gui.Element;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.ScreenTexts;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.util.math.MatrixStack;
import net.minecraft.text.LiteralText;
import net.minecraft.text.StringVisitable;
import net.minecraft.text.Text;
import net.minecraft.text.TranslatableText;
import net.minecraft.util.Util;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain;
import rege.rege.minecraftmod.customsavedirs.text.I18nHelper;

public class CustomSaveDirsScreen
extends Screen {
    public static final Logger LOGGER = LoggerFactory.getLogger(CustomSaveDirsScreen.class);
    private static @Range(from=0L, to=0x7FFFFFFFL) int CURRENT_DIR = 0;
    public static final TranslatableText TITLE_TEXT = new TranslatableText("options.savedirs.title");
    public static final TranslatableText EDIT_FILE_TEXT = new TranslatableText("options.savedirs.editfile");
    public static final TranslatableText LOAD_FILE_TEXT = new TranslatableText("options.savedirs.loadfile");
    public static final TranslatableText EDIT_FILE_TOOLTIP = new TranslatableText("options.savedirs.editfile.tooltip", new Object[]{Path.of("config/customsavedirs.json", new String[0]).toAbsolutePath().toString()});
    public static final TranslatableText LOAD_FILE_TOOLTIP = new TranslatableText("options.savedirs.loadfile.tooltip");
    public static final TranslatableText CURRENT_DIR_TOOLTIP = new TranslatableText("options.savedirs.current.tooltip");
    public static final TranslatableText CURRENT_UNAVAIL_DIR_TOOLTIP = new TranslatableText("options.savedirs.current.unavailable.tooltip");
    public final ButtonWidget currentDirButton;
    public final ButtonWidget editFileButton;
    public final ButtonWidget loadFileButton;
    private final Screen parent;

    @Contract(pure=true)
    public static @Range(from=0L, to=0x7FFFFFFFL) int getCurrentDir() {
        return CURRENT_DIR;
    }

    public static @Range(from=0L, to=0x7FFFFFFFL) int setCurrentDir(@Range(from=0L, to=0x7FFFFFFFL) int currentDir) {
        if (currentDir < 0) {
            throw new IllegalArgumentException();
        }
        int RES = CURRENT_DIR;
        CURRENT_DIR = CustomSaveDirsMain.SAVE_DIRS.isEmpty() ? 0 : currentDir % CustomSaveDirsMain.SAVE_DIRS.size();
        return RES;
    }

    public static Text textProvider() {
        CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir());
        if (CustomSaveDirsMain.SAVE_DIRS.isEmpty()) {
            return I18nHelper.translateOrFallback("options.savedirs.current", "Current", new Object[0]).append((Text)new LiteralText(": ")).append((Text)new TranslatableText("options.gamma.default"));
        }
        String DIR_PTH = CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir());
        return (CustomSaveDirsMain.getCachedLevelStorages(DIR_PTH) == null ? I18nHelper.translateOrFallback("options.savedirs.current.unavailable", "Current (unavailable now)", new Object[0]) : I18nHelper.translateOrFallback("options.savedirs.current", "Current", new Object[0])).append((Text)new LiteralText(": " + CustomSaveDirsScreen.getCurrentDir() + ": " + DIR_PTH));
    }

    public CustomSaveDirsScreen(Screen parent) {
        super((Text)TITLE_TEXT);
        this.parent = parent;
        this.currentDirButton = new ButtonWidget(this.width / 2 - 155, 40, 310, 20, CustomSaveDirsScreen.textProvider(), button -> {
            CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir() + 1);
            this.init();
            button.setMessage(CustomSaveDirsScreen.textProvider());
        });
        this.editFileButton = new ButtonWidget(this.width / 2 - 155, 64, 310, 20, (Text)I18nHelper.translateOrFallback(EDIT_FILE_TEXT.getKey(), "Edit customsavedirs.json", new Object[0]), button -> {
            File file = new File("config");
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            if (!(file = new File(file, "customsavedirs.json")).isFile()) {
                LOGGER.info("config/customsavedirs.json not exist, creating...");
                try {
                    FileWriter FW = new FileWriter(file);
                    FW.write("[]");
                    FW.close();
                }
                catch (IOException e) {
                    LOGGER.error("cannot create file config/customsavedirs.json", (Throwable)e);
                }
            }
            Util.getOperatingSystem().open(new File("config/customsavedirs.json"));
        });
        this.loadFileButton = new ButtonWidget(this.width / 2 - 155, 88, 310, 20, (Text)I18nHelper.translateOrFallback(LOAD_FILE_TEXT.getKey(), "Reload customsavedirs.json", new Object[0]), button -> {
            CustomSaveDirsMain.loadConfig(new File("config/customsavedirs.json"));
            CustomSaveDirsMain.cleanUpCachedLevelStorages();
            if (this.client != null) {
                CustomSaveDirsMain.createLevelStoragesToCache(this.client.getLevelStorage());
            }
            this.currentDirButton.setMessage(CustomSaveDirsScreen.textProvider());
        });
    }

    public static void draw(@NotNull CustomSaveDirsScreen scr) {
        scr.currentDirButton.x = scr.width / 2 - 155;
        scr.editFileButton.x = scr.width / 2 - 155;
        scr.loadFileButton.x = scr.width / 2 - 155;
        scr.addDrawableChild((Element)scr.currentDirButton);
        scr.addDrawableChild((Element)scr.editFileButton);
        scr.addDrawableChild((Element)scr.loadFileButton);
        scr.addDrawableChild((Element)new ButtonWidget(scr.width / 2 - 100, scr.height - 27, 200, 20, ScreenTexts.DONE, button -> {
            if (scr.client != null) {
                scr.client.setScreen(scr.parent);
            }
        }));
    }

    protected void init() {
        this.clearChildren();
        CustomSaveDirsScreen.draw(this);
    }

    public void render(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.renderBackground(matrices);
        CustomSaveDirsScreen.drawCenteredText((MatrixStack)matrices, (TextRenderer)this.textRenderer, (Text)I18nHelper.translateOrFallback(TITLE_TEXT.getKey(), "Save Directories", new Object[0]), (int)(this.width / 2), (int)15, (int)0xFFFFFF);
        super.render(matrices, mouseX, mouseY, delta);
        if (this.currentDirButton != null && this.client != null && this.currentDirButton.isMouseOver((double)mouseX, (double)mouseY)) {
            if (!CustomSaveDirsMain.SAVE_DIRS.isEmpty() && CustomSaveDirsMain.getCachedLevelStorages(CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir())) == null) {
                this.renderOrderedTooltip(matrices, this.client.textRenderer.wrapLines((StringVisitable)I18nHelper.translateOrFallback(CURRENT_UNAVAIL_DIR_TOOLTIP.getKey(), "The current directory is unavailable due to an OS-level IO error. Default directory will be used instead.", new Object[0]), 200), mouseX, mouseY);
            } else if (this.client.isIntegratedServerRunning()) {
                this.renderOrderedTooltip(matrices, this.client.textRenderer.wrapLines((StringVisitable)I18nHelper.translateOrFallback(CURRENT_DIR_TOOLTIP.getKey(), "This option will be applied after you save and exit the current world", new Object[0]), 200), mouseX, mouseY);
            }
        }
        if (this.editFileButton != null && this.client != null && this.editFileButton.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderOrderedTooltip(matrices, this.client.textRenderer.wrapLines((StringVisitable)I18nHelper.translateOrFallback(EDIT_FILE_TOOLTIP.getKey(), "By clicking this button an editor will open. If not, please manually open %s", Path.of("config/customsavedirs.json", new String[0]).toAbsolutePath().toString()), 200), mouseX, mouseY);
        }
        if (this.loadFileButton != null && this.client != null && this.loadFileButton.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderOrderedTooltip(matrices, this.client.textRenderer.wrapLines((StringVisitable)I18nHelper.translateOrFallback(LOAD_FILE_TOOLTIP.getKey(), "The content of customsavedirs.json should be a valid JSON array with zero, one or multiple strings. These strings represent save directories.", new Object[0]), 200), mouseX, mouseY);
        }
    }
}

