package rege.rege.minecraftmod.customsavedirs;

import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_32;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import static org.slf4j.LoggerFactory.getLogger;

public class CustomSaveDirsMain implements ClientModInitializer {
    public static final ArrayList<String> SAVE_DIRS = new ArrayList<>();
    private static final HashMap<String, class_32> CACHED_LEVEL_STORAGES =
    new HashMap<>();
    public static final Logger LOGGER = getLogger(CustomSaveDirsMain.class);
    public static final class_2588 CONFIGURE_SAVE_DIRECTORIES_TEXT =
    new class_2588("options.savedirs");

    @Contract(pure = true)
    public static @Nullable RuntimeException validate(@NotNull String path) {
        try {
            Path.of(path);
        } catch (RuntimeException e) {
            return e;
        }
        return null;
    }

    public static void
    createLevelStoragesToCache(@NotNull class_32 builtin) {
        for (String i : SAVE_DIRS) {
            try {
                CACHED_LEVEL_STORAGES.put(i, new class_32(
                    Path.of(i), builtin.method_236(),
                    class_310.method_1551().method_1543()
                ));
            } catch (IOError e) {
                LOGGER.error("Unable to cache level storage of " + i +
                             " due to an OS-level IO error", e);
            }
        }
    }

    public static void cleanUpCachedLevelStorages() {
        for (String i : new HashSet<>(CACHED_LEVEL_STORAGES.keySet())) {
            if (!SAVE_DIRS.contains(i)) {
                CACHED_LEVEL_STORAGES.remove(i);
            }
        }
    }

    @Contract(pure = true)
    public static @Nullable class_32
    getCachedLevelStorages(@NotNull String path) {
        return CACHED_LEVEL_STORAGES.get(path);
    }

    @SuppressWarnings("deprecation")
    public static void loadConfig(@NotNull File configFile) {
        if (configFile.isFile()) {
            try {
                final FileReader FR = new FileReader(configFile);
                final StringBuilder SB = new StringBuilder();
                int ach;
                while ((ach = FR.read()) != -1) {
                    SB.append((char)ach);
                }
                FR.close();
                final JsonElement JE = new JsonParser().parse(SB.toString());
                SAVE_DIRS.clear();
                if (JE.isJsonArray()) {
                    for (JsonElement i : JE.getAsJsonArray()) {
                        final String STR = i.getAsString();
                        final RuntimeException VALIDATION = validate(STR);
                        if (VALIDATION == null) {
                            SAVE_DIRS.add(i.getAsString());
                        } else {
                            LOGGER.warn("Will not load directory " + STR,
                                        VALIDATION);
                        }
                    }
                }
                LOGGER.info(
                    "Loaded these directories from config/customsavedirs.json:"
                );
                for (String i : SAVE_DIRS) {
                    LOGGER.info(i);
                }
            } catch (IOException e) {
                LOGGER.warn("Failed to read file config/customsavedirs.json");
            } catch (RuntimeException e) {
                LOGGER.error("Error loading config/customsavedirs.json", e);
            }
        } else {
            LOGGER.info("Normal file config/customsavedirs.json not found.");
            LOGGER.info("Now use default save directory.");
        }
    }

    static {
        loadConfig(new File("config/customsavedirs.json"));
        cleanUpCachedLevelStorages();
    }

    @Override
    @Contract(pure = true)
    public void onInitializeClient() {}
}
