package rege.rege.minecraftmod.customsavedirs.gui.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.slf4j.Logger;

import static net.minecraft.class_5244.field_24334;
import static org.slf4j.LoggerFactory.getLogger;
import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain.*;
import static rege.rege.minecraftmod.customsavedirs.text.I18nHelper.translateOrFallback;

public class CustomSaveDirsScreen extends class_437 {
    public static final Logger LOGGER = getLogger(CustomSaveDirsScreen.class);
    private static @Range(from = 0, to = Integer.MAX_VALUE) int CURRENT_DIR =0;
    public static final class_2588 TITLE_TEXT =
    new class_2588("options.savedirs.title");
    public static final class_2588 EDIT_FILE_TEXT =
    new class_2588("options.savedirs.editfile");
    public static final class_2588 LOAD_FILE_TEXT =
    new class_2588("options.savedirs.loadfile");
    public static final class_2588 EDIT_FILE_TOOLTIP =
    new class_2588("options.savedirs.editfile.tooltip", Path.of(
        "config/customsavedirs.json"
    ).toAbsolutePath().toString());
    public static final class_2588 LOAD_FILE_TOOLTIP =
    new class_2588("options.savedirs.loadfile.tooltip");
    public static final class_2588 CURRENT_DIR_TOOLTIP =
    new class_2588("options.savedirs.current.tooltip");
    public static final class_2588 CURRENT_UNAVAIL_DIR_TOOLTIP =
    new class_2588("options.savedirs.current.unavailable.tooltip");

    @Contract(pure = true)
    public static @Range(from = 0, to = Integer.MAX_VALUE) int getCurrentDir(){
        return CURRENT_DIR;
    }

    public static @Range(from = 0, to = Integer.MAX_VALUE) int
    setCurrentDir(@Range(from = 0, to = Integer.MAX_VALUE) int currentDir) {
        if (currentDir < 0) {
            throw new IllegalArgumentException();
        }
        final int RES = CURRENT_DIR;
        CURRENT_DIR = SAVE_DIRS.isEmpty() ? 0 :(currentDir % SAVE_DIRS.size());
        return RES;
    }

    public static class_2561 textProvider() {
        setCurrentDir(getCurrentDir());
        if (SAVE_DIRS.isEmpty()) {
            return translateOrFallback(
                "options.savedirs.current", "Current"
            ).method_10852(new class_2585(": ")).method_10852(
                new class_2588("options.gamma.default")
            );
        }
        final String DIR_PTH = SAVE_DIRS.get(getCurrentDir());
        return ((getCachedLevelStorages(DIR_PTH) == null) ?
                translateOrFallback(
            "options.savedirs.current.unavailable", "Current (unavailable now)"
        ) : translateOrFallback(
            "options.savedirs.current", "Current"
        )).method_10852(new class_2585(": " + getCurrentDir() + ": " + DIR_PTH));
    }

    public final class_4185 currentDirButton;
    public final class_4185 editFileButton;
    public final class_4185 loadFileButton;
    private final class_437 parent;

    public CustomSaveDirsScreen(class_437 parent) {
        super(TITLE_TEXT);
        this.parent = parent;
        this.currentDirButton = new class_4185(
            this.field_22789 / 2 - 155, 40, 310, 20, textProvider(), button -> {
                setCurrentDir(getCurrentDir() + 1);
                this.method_25426();
                button.method_25355(textProvider());
            }
        );
        this.editFileButton = new class_4185(
            this.field_22789 / 2 - 155, 64, 310, 20, translateOrFallback(
                EDIT_FILE_TEXT.method_11022(), "Edit customsavedirs.json"
            ), button -> {
                File file = new File("config");
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                file = new File(file, "customsavedirs.json");
                if (!file.isFile()) {
                    LOGGER.info(
                        "config/customsavedirs.json not exist, creating..."
                    );
                    try {
                        final FileWriter FW = new FileWriter(file);
                        FW.write("[]");
                        FW.close();
                    } catch (IOException e) {
                        LOGGER.error(
                            "cannot create file config/customsavedirs.json", e
                        );
                    }
                }
                class_156.method_668().method_672(new File(
                    "config/customsavedirs.json"
                ));
            }
        );
        this.loadFileButton = new class_4185(
            this.field_22789 / 2 - 155, 88, 310, 20, translateOrFallback(
                LOAD_FILE_TEXT.method_11022(), "Reload customsavedirs.json"
            ), button -> {
                loadConfig(new File("config/customsavedirs.json"));
                cleanUpCachedLevelStorages();
                if (this.field_22787 != null) {
                    createLevelStoragesToCache(this.field_22787.method_1586());
                }
                this.currentDirButton.method_25355(textProvider());
            }
        );
    }

    public static void draw(@NotNull CustomSaveDirsScreen scr) {
        scr.currentDirButton.field_22760 = scr.field_22789 / 2 - 155;
        scr.editFileButton.field_22760 = scr.field_22789 / 2 - 155;
        scr.loadFileButton.field_22760 = scr.field_22789 / 2 - 155;
        scr.method_37063(scr.currentDirButton);
        scr.method_37063(scr.editFileButton);
        scr.method_37063(scr.loadFileButton);
        scr.method_37063(new class_4185(
            scr.field_22789 / 2 - 100, scr.field_22790 - 27, 200, 20, field_24334, button -> {
                if (scr.field_22787 != null) {
                    scr.field_22787.method_1507(scr.parent);
                }
            }
        ));
    }

    @Override
    protected void method_25426() {
        this.method_37067();
        CustomSaveDirsScreen.draw(this);
    }

    @Override
    public void
    method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        method_27534(matrices, this.field_22793, translateOrFallback(
            TITLE_TEXT.method_11022(), "Save Directories"
        ), this.field_22789 / 2, 15, 16777215);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.currentDirButton != null && this.field_22787 != null &&
            this.currentDirButton.method_25405(mouseX, mouseY)) {
            if ((!SAVE_DIRS.isEmpty()) &&
                getCachedLevelStorages(SAVE_DIRS.get(getCurrentDir()))==null) {
                this.method_25417(
                    matrices, this.field_22787.field_1772.method_1728(
                        translateOrFallback(
                            CURRENT_UNAVAIL_DIR_TOOLTIP.method_11022(),
                            "The current directory is unavailable due to an OS-level IO error. Default directory will be used instead."
                        ), 200
                    ), mouseX, mouseY
                );
            } else if (this.field_22787.method_1496()) {
                this.method_25417(
                    matrices, this.field_22787.field_1772.method_1728(
                        translateOrFallback(
                            CURRENT_DIR_TOOLTIP.method_11022(),
                            "This option will be applied after you save and exit the current world"
                        ), 200
                    ), mouseX, mouseY
                );
            }
        }
        if (this.editFileButton != null && this.field_22787 != null &&
            this.editFileButton.method_25405(mouseX, mouseY)) {
            this.method_25417(
                matrices, this.field_22787.field_1772.method_1728(
                    translateOrFallback(
                        EDIT_FILE_TOOLTIP.method_11022(),
                        "By clicking this button an editor will open. If not, please manually open %s",
                        Path.of("config/customsavedirs.json").toAbsolutePath()
                        .toString()
                    ), 200
                ), mouseX, mouseY
            );
        }
        if (this.loadFileButton != null && this.field_22787 != null &&
            this.loadFileButton.method_25405(mouseX, mouseY)) {
            this.method_25417(
                matrices, this.field_22787.field_1772.method_1728(
                    translateOrFallback(
                        LOAD_FILE_TOOLTIP.method_11022(),
                        "The content of customsavedirs.json should be a valid JSON array with zero, one or multiple strings. These strings represent save directories."
                    ), 200
                ), mouseX, mouseY
            );
        }
    }
}
