package rege.rege.minecraftmod.customsavedirs.gui.widget;

import net.minecraft.class_339;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public abstract class WidgetAutoLocator {
    public static boolean isColliding(
        @NotNull class_339 widget, int w2sx, int w2sy, int w2ex, int w2ey
    ) {
        int wsx = widget.field_22760;
        int wsy = widget.field_22761;
        int wex = wsx + widget.method_25368();
        int wey = wsy + widget.method_25364();;
        return (wey > w2sy) && (wsy < w2ey) && (wex > w2sx) && (wsx < w2ex);
    }

//    public static @Range(from = -1L, to = 1L << 62) long getPackedLocation(
//        @NotNull Iterable<ClickableWidget> otherWidgets,
//        @NotNull ClickableWidget targetWidget,
//        @Range(from = 0, to = Integer.MAX_VALUE) int targetWidth,
//        @Range(from = 0, to = Integer.MAX_VALUE) int targetHeight,
//        @Range(from = 0, to = Integer.MAX_VALUE) int minXInclusive,
//        @Range(from = 0, to = Integer.MAX_VALUE) int minYInclusive,
//        @Range(from = 0, to = Integer.MAX_VALUE) int maxXInclusive,
//        @Range(from = 0, to = Integer.MAX_VALUE) int maxYInclusive
//    ) {
//        for (ClickableWidget i : otherWidgets) {
//
//        }
//    }

    public static @Range(from = -1L, to = 1L << 62) long
    getGriddedPackedLocation(
        final @NotNull Iterable<@NotNull class_339> otherWidgets,
        final @Range(from = 1, to = Integer.MAX_VALUE) int targetWidgetWidth,
        final @Range(from = 1, to = Integer.MAX_VALUE) int targetWidgetHeight,
        final @Range(from = 0, to = Integer.MAX_VALUE) int tlX,
        final @Range(from = 0, to = Integer.MAX_VALUE) int tlY,
        final @Range(from = 0, to = Integer.MAX_VALUE) int rows,
        final @Range(from = 1, to = Integer.MAX_VALUE) int cols,
        final @Range(from = 0, to = Integer.MAX_VALUE) int rowSep,
        final @Range(from = 0, to = Integer.MAX_VALUE) int colSep
    ) {
        int rrow = 0;
        int rcol = 0;
        while (rows <= 0 || rrow < rows) {
            boolean success = true;
            int testsx = tlX + (colSep * rcol);
            int testsy = tlY + (rowSep * rrow);
            for (class_339 i : otherWidgets) {
                if (isColliding(i, testsx, testsy, testsx + targetWidgetWidth,
                                testsy + targetWidgetHeight)) {
                    success = false;
                    break;
                }
            }
            if (success) {
                return (((long)testsx) << 31L) | testsy;
            }
            if (rcol + 1 >= cols) {
                rrow++;
                rcol = 0;
            } else {
                rcol++;
            }
        }
        return -1L;
    }

    @Contract("-> fail")
    private WidgetAutoLocator() {
        throw new UnsupportedOperationException();
    }
}
