package rege.rege.minecraftmod.customsavedirs.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain
              .SAVE_DIRS;
import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain
              .createLevelStoragesToCache;
import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain
              .getCachedLevelStorages;
import static rege.rege.minecraftmod.customsavedirs.gui.screen
              .CustomSaveDirsScreen.getCurrentDir;
import static rege.rege.minecraftmod.customsavedirs.gui.screen
              .CustomSaveDirsScreen.setCurrentDir;

import net.minecraft.class_32;

@Mixin(net.minecraft.class_310.class)
public abstract class ModifyDefaultSaveDirMixin {
    @Shadow
    public abstract class_32 getLevelStorage();

    @Inject(method = "<init>", at = @At("RETURN"))
    private void cacheStorages(CallbackInfo info) {
        createLevelStoragesToCache(this.getLevelStorage());
    }

    @Inject(method = "getLevelStorage", at = @At("RETURN"), cancellable = true)
    private void
    injectGetLevelStorage(CallbackInfoReturnable<class_32> info) {
        if (!SAVE_DIRS.isEmpty()) {
            if (getCurrentDir() >= SAVE_DIRS.size()) {
                setCurrentDir(SAVE_DIRS.size() - 1);
            }
            final class_32 LS = getCachedLevelStorages(SAVE_DIRS.get(
                getCurrentDir()
            ));
            if (LS != null) {
                info.setReturnValue(LS);
            } else {
                System.err.println("cached level storage is null!");
            }
        }
    }

    @ModifyArg(method = "method_29600", at = @At(
        value = "INVOKE",
        target =
        "Lnet/minecraft/client/gui/screen/world/EditWorldScreen;onBackupConfirm(Lnet/minecraft/world/level/storage/LevelStorage;Ljava/lang/String;)V"
    ), index = 0)
    private class_32 injected(class_32 storage) {
        if (!SAVE_DIRS.isEmpty()) {
            if (getCurrentDir() >= SAVE_DIRS.size()) {
                setCurrentDir(SAVE_DIRS.size() - 1);
            }
            final class_32 LS = getCachedLevelStorages(SAVE_DIRS.get(
                getCurrentDir()
            ));
            if (LS != null) {
                return LS;
            }
            System.err.println("cached level storage is null!");
        }
        return storage;
    }
}
