/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs;

import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.world.level.storage.AnvilLevelStorage;
import net.minecraft.world.level.storage.LevelStorageAccess;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rege.rege.misc.customsavedirs.cc0fork.SimpleJSON;

public class CustomSaveDirsMain
implements ClientModInitializer {
    public static final ArrayList<String> SAVE_DIRS = new ArrayList();
    private static final HashMap<String, LevelStorageAccess> CACHED_LEVEL_STORAGES = new HashMap();
    public static final Logger LOGGER = Logger.getLogger(CustomSaveDirsMain.class.getName());
    public static final String CONFIGURE_SAVE_DIRECTORIES_KEY = "options.savedirs";

    @Nullable
    public static RuntimeException validate(@NotNull String path) {
        try {
            FileSystems.getDefault().getPath(path, new String[0]);
        }
        catch (RuntimeException e) {
            return e;
        }
        return null;
    }

    public static void createLevelStoragesToCache() {
        for (String i : SAVE_DIRS) {
            try {
                CACHED_LEVEL_STORAGES.put(i, (LevelStorageAccess)new AnvilLevelStorage(new File(i)));
            }
            catch (IOError e) {
                LOGGER.log(Level.SEVERE, "Unable to cache level storage of " + i + " due to an OS-level IO error", e);
            }
        }
    }

    public static void cleanUpCachedLevelStorages() {
        for (String i : new HashSet<String>(CACHED_LEVEL_STORAGES.keySet())) {
            if (SAVE_DIRS.contains(i)) continue;
            CACHED_LEVEL_STORAGES.remove(i);
        }
    }

    @Contract(pure=true)
    @Nullable
    public static LevelStorageAccess getCachedLevelStorages(@NotNull String path) {
        return CACHED_LEVEL_STORAGES.get(path);
    }

    public static void loadConfig(@NotNull File configFile) {
        if (configFile.isFile()) {
            try {
                int ach;
                FileReader FR = new FileReader(configFile);
                StringBuilder SB = new StringBuilder();
                while ((ach = FR.read()) != -1) {
                    SB.append((char)ach);
                }
                FR.close();
                SimpleJSON JE = SimpleJSON.parseJSON(SB.toString());
                SAVE_DIRS.clear();
                if (JE.type == SimpleJSON.JSONType.ARRAY) {
                    for (SimpleJSON simpleJSON : JE.toList()) {
                        String STR = simpleJSON.type == SimpleJSON.JSONType.STRING ? simpleJSON.getAsString() : simpleJSON.toString();
                        RuntimeException VALIDATION = CustomSaveDirsMain.validate(STR);
                        if (VALIDATION == null) {
                            SAVE_DIRS.add(STR);
                            continue;
                        }
                        LOGGER.log(Level.WARNING, "Will not load directory " + STR, VALIDATION);
                    }
                }
                LOGGER.info("Loaded these directories from config/customsavedirs.json:");
                for (String string : SAVE_DIRS) {
                    LOGGER.info(string);
                }
            }
            catch (IOException e) {
                LOGGER.warning("Failed to read file config/customsavedirs.json");
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, "Error loading config/customsavedirs.json", e);
            }
        } else {
            LOGGER.info("Normal file config/customsavedirs.json not found.");
            LOGGER.info("Now use default save directory.");
        }
    }

    @Contract(pure=true)
    public void onInitializeClient() {
    }

    static {
        CustomSaveDirsMain.loadConfig(new File("config/customsavedirs.json"));
        CustomSaveDirsMain.cleanUpCachedLevelStorages();
    }
}

