/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs.gui.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.util.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.lwjgl.Sys;
import rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain;
import rege.rege.minecraftmod.customsavedirs.text.I18nHelper;

public class CustomSaveDirsScreen
extends Screen {
    public static final int CONFIGURE_SAVE_DIRECTORIES_BUTTON_ID = 123595003;
    public static final int CURRENT_DIR_BUTTON_ID = 923722340;
    public static final int EDIT_FILE_BUTTON_ID = 878847879;
    public static final int LOAD_FILE_BUTTON_ID = 488411916;
    public static final int DONE_BUTTON_ID = 309638920;
    public static final Logger LOGGER = Logger.getLogger(CustomSaveDirsScreen.class.getName());
    private static @Range(from=0L, to=0x7FFFFFFFL) int CURRENT_DIR = 0;
    public static final String TITLE_KEY = "options.savedirs.title";
    public static final String EDIT_FILE_KEY = "options.savedirs.editfile";
    public static final String LOAD_FILE_KEY = "options.savedirs.loadfile";
    public static final String EDIT_FILE_TOOLTIP_KEY = "options.savedirs.editfile.tooltip";
    public static final String LOAD_FILE_TOOLTIP_KEY = "options.savedirs.loadfile.tooltip";
    public static final String CURRENT_DIR_TOOLTIP_KEY = "options.savedirs.current.tooltip";
    public static final String CURRENT_UNAVAIL_DIR_TOOLTIP_KEY = "options.savedirs.current.unavailable.tooltip";
    public final ButtonWidget currentDirButton;
    public final ButtonWidget editFileButton;
    public final ButtonWidget loadFileButton;
    private final Screen parent;

    @Contract(pure=true)
    public static @Range(from=0L, to=0x7FFFFFFFL) int getCurrentDir() {
        return CURRENT_DIR;
    }

    public static @Range(from=0L, to=0x7FFFFFFFL) int setCurrentDir(@Range(from=0L, to=0x7FFFFFFFL) int currentDir) {
        if (currentDir < 0) {
            throw new IllegalArgumentException();
        }
        int RES = CURRENT_DIR;
        CURRENT_DIR = CustomSaveDirsMain.SAVE_DIRS.isEmpty() ? 0 : currentDir % CustomSaveDirsMain.SAVE_DIRS.size();
        return RES;
    }

    public static String textProvider() {
        CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir());
        if (CustomSaveDirsMain.SAVE_DIRS.isEmpty()) {
            return I18nHelper.translateOrFallback("options.savedirs.current", "Current", new Object[0]) + ": " + Language.getInstance().translate("generator.default");
        }
        String DIR_PTH = CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir());
        return (CustomSaveDirsMain.getCachedLevelStorages(DIR_PTH) == null ? I18nHelper.translateOrFallback("options.savedirs.current.unavailable", "Current (unavailable now)", new Object[0]) : I18nHelper.translateOrFallback("options.savedirs.current", "Current", new Object[0])) + ": " + CustomSaveDirsScreen.getCurrentDir() + ": " + DIR_PTH;
    }

    @Nullable
    public static Process openFile(@NotNull String name, @Nullable Logger logger) {
        block15: {
            String osname = System.getProperty("os.name");
            if (osname != null) {
                if ((osname = osname.toLowerCase()).contains("mac")) {
                    try {
                        return Runtime.getRuntime().exec(new String[]{"/usr/bin/open", name});
                    }
                    catch (IOException e) {
                        if (logger != null) {
                            logger.log(Level.SEVERE, "Couldn't open file " + name, e);
                        }
                        break block15;
                    }
                }
                if (osname.contains("win") || osname.contains("react")) {
                    try {
                        return Runtime.getRuntime().exec(String.format("cmd.exe /C start \"Open file\" \"%s\"", name));
                    }
                    catch (IOException e) {
                        if (logger != null) {
                            logger.log(Level.SEVERE, "Couldn't open file " + name, e);
                        }
                        break block15;
                    }
                }
                if (osname.contains("linux") || osname.contains("bsd")) {
                    try {
                        return Runtime.getRuntime().exec(new String[]{"xdg-open", name});
                    }
                    catch (IOException e) {
                        if (logger == null) break block15;
                        logger.log(Level.SEVERE, "Couldn't open file " + name, e);
                    }
                }
            }
        }
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Object desktop = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            clazz.getMethod("open", File.class).invoke(desktop, new File(name));
        }
        catch (Throwable throwable) {
            if (logger != null) {
                LOGGER.log(Level.SEVERE, "Couldn't open file", throwable);
                LOGGER.info("Opening via system class!");
            }
            Sys.openURL((String)("file://" + name));
        }
        return null;
    }

    public CustomSaveDirsScreen(Screen parent) {
        this.parent = parent;
        this.currentDirButton = new ButtonWidget(923722340, this.width / 2 - 155, 40, 310, 20, CustomSaveDirsScreen.textProvider());
        this.editFileButton = new ButtonWidget(878847879, this.width / 2 - 155, 64, 310, 20, I18nHelper.translateOrFallback(EDIT_FILE_KEY, "Edit customsavedirs.json", new Object[0]));
        this.loadFileButton = new ButtonWidget(488411916, this.width / 2 - 155, 88, 310, 20, I18nHelper.translateOrFallback(LOAD_FILE_KEY, "Reload customsavedirs.json", new Object[0]));
    }

    public static void draw(@NotNull CustomSaveDirsScreen scr) {
        scr.currentDirButton.x = scr.width / 2 - 155;
        scr.editFileButton.x = scr.width / 2 - 155;
        scr.loadFileButton.x = scr.width / 2 - 155;
        scr.buttons.add(scr.currentDirButton);
        scr.buttons.add(scr.editFileButton);
        scr.buttons.add(scr.loadFileButton);
        scr.buttons.add(new ButtonWidget(309638920, scr.width / 2 - 100, scr.height - 27, 200, 20, Language.getInstance().translate("gui.done")));
    }

    public void init() {
        this.buttons.clear();
        CustomSaveDirsScreen.draw(this);
    }

    public void buttonClicked(ButtonWidget button) {
        if (button.active) {
            if (button == this.currentDirButton) {
                CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir() + 1);
                button.message = CustomSaveDirsScreen.textProvider();
                this.init();
            } else if (button == this.editFileButton) {
                File file = new File("config");
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                if (!(file = new File(file, "customsavedirs.json")).isFile()) {
                    LOGGER.info("config/customsavedirs.json not exist, creating...");
                    try {
                        FileWriter FW = new FileWriter(file);
                        FW.write("[]");
                        FW.close();
                    }
                    catch (IOException e2) {
                        LOGGER.log(Level.SEVERE, "cannot create file config/customsavedirs.json", e2);
                    }
                }
                CustomSaveDirsScreen.openFile(new File("config/customsavedirs.json").getAbsolutePath(), LOGGER);
            } else if (button == this.loadFileButton) {
                CustomSaveDirsMain.loadConfig(new File("config/customsavedirs.json"));
                CustomSaveDirsMain.cleanUpCachedLevelStorages();
                if (this.field_1229 != null) {
                    CustomSaveDirsMain.createLevelStoragesToCache();
                }
                this.currentDirButton.message = CustomSaveDirsScreen.textProvider();
            } else if (button.id == 309638920 && this.field_1229 != null) {
                this.field_1229.openScreen(this.parent);
            }
        }
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.renderBackground();
        if (this.field_1229 != null) {
            this.drawCenteredString(this.field_1229.textRenderer, I18nHelper.translateOrFallback(TITLE_KEY, "Save Directories", new Object[0]), this.width / 2, 15, 0xFFFFFF);
        }
        super.render(mouseX, mouseY, delta);
    }
}

