/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs.gui.widget;

import net.minecraft.client.gui.widget.ButtonWidget;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import rege.rege.minecraftmod.customsavedirs.mixin.ButtonWidgetAccessor;

public abstract class WidgetAutoLocator {
    public static boolean isColliding(@NotNull ButtonWidget widget, int w2sx, int w2sy, int w2ex, int w2ey) {
        int wsx = widget.x;
        int wsy = widget.y;
        int wex = wsx + ((ButtonWidgetAccessor)widget).getWidth();
        int wey = wsy + ((ButtonWidgetAccessor)widget).getHeight();
        return wey > w2sy && wsy < w2ey && wex > w2sx && wsx < w2ex;
    }

    public static @Range(from=-1L, to=0x4000000000000000L) long getGriddedPackedLocation(@NotNull @NotNull Iterable<@NotNull ButtonWidget> otherWidgets, @Range(from=1L, to=0x7FFFFFFFL) int targetWidgetWidth, @Range(from=1L, to=0x7FFFFFFFL) int targetWidgetHeight, @Range(from=0L, to=0x7FFFFFFFL) int tlX, @Range(from=0L, to=0x7FFFFFFFL) int tlY, @Range(from=0L, to=0x7FFFFFFFL) int rows, @Range(from=1L, to=0x7FFFFFFFL) int cols, @Range(from=0L, to=0x7FFFFFFFL) int rowSep, @Range(from=0L, to=0x7FFFFFFFL) int colSep) {
        int rrow = 0;
        int rcol = 0;
        while (rows <= 0 || rrow < rows) {
            boolean success = true;
            int testsx = tlX + colSep * rcol;
            int testsy = tlY + rowSep * rrow;
            for (ButtonWidget i : otherWidgets) {
                if (!WidgetAutoLocator.isColliding(i, testsx, testsy, testsx + targetWidgetWidth, testsy + targetWidgetHeight)) continue;
                success = false;
                break;
            }
            if (success) {
                return (long)testsx << 31 | (long)testsy;
            }
            if (rcol + 1 >= cols) {
                ++rrow;
                rcol = 0;
                continue;
            }
            ++rcol;
        }
        return -1L;
    }

    @Contract(value="-> fail")
    private WidgetAutoLocator() {
        throw new UnsupportedOperationException();
    }
}

