/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.misc.customsavedirs.cc0fork;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleJSON {
    public static final char STRING_WRAP = '\"';
    public static final char ITEM_SEP = ',';
    public static final char KEY_VALUE = ':';
    public static final char ARRAY_START = '[';
    public static final char ARRAY_END = ']';
    public static final char OBJECT_START = '{';
    public static final char OBJECT_END = '}';
    public static final String FALSE_IDENTIFIER = "false";
    public static final String TRUE_IDENTIFIER = "true";
    public static final String NULL_IDENTIFIER = "null";
    public static final String WHITESPACES = "\t\n\r ";
    public static final String STRING_ALLOWED_WHITESPACES = " ";
    public static final char MINUS_SIGN = '-';
    public static final char PLUS_SIGN = '+';
    public static final char ZERO = '0';
    public static final char DECIMAL_POINT = '.';
    public static final String EXPONENT = "Ee";
    public static final String DIGITS = "0123456789";
    public static final char ESCAPE_START = '\\';
    private static final HashMap<@NotNull Character, @NotNull String> ESCAPE_RESULTS = new HashMap();
    private static final HashMap<@NotNull Character, @NotNull Byte> UNICODE_ESCAPE_VALUES;
    public final JSONType type;
    @Nullable
    private final String content;
    @Nullable
    private final ArrayList<SimpleJSON> ifArray;
    @Nullable
    private final ArrayList<KVPair> ifObject;

    private static boolean containsChar(@NotNull String str, char ch) {
        for (char i : str.toCharArray()) {
            if (i != ch) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static SimpleJSON parseJSON(@NotNull String str) throws IllegalArgumentException {
        int ptr;
        KVPair PAIR = SimpleJSON.parse(str, 0, false);
        int LEN = str.length();
        for (ptr = Integer.parseInt(PAIR.getKey()); ptr < LEN && SimpleJSON.containsChar(WHITESPACES, str.charAt(ptr)); ++ptr) {
        }
        if (ptr < LEN) {
            throw new IllegalArgumentException("extra content beyond char " + ptr);
        }
        return PAIR.getValue();
    }

    @NotNull
    private static KVPair parse(@NotNull String str, int pointer, boolean stringOnly) throws IllegalArgumentException {
        int LEN = str.length();
        try {
            while (SimpleJSON.containsChar(WHITESPACES, str.charAt(pointer))) {
                ++pointer;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("no data found");
        }
        char achar = str.charAt(pointer);
        if (achar == '{' && !stringOnly) {
            SimpleJSON json = new SimpleJSON(new HashMap());
            ++pointer;
            while (pointer < LEN && SimpleJSON.containsChar(WHITESPACES, str.charAt(pointer))) {
                ++pointer;
            }
            try {
                if (str.charAt(pointer) == '}') {
                    return new KVPair(Integer.toString(pointer + 1), json);
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("'{' was never closed");
            }
            while (pointer < LEN) {
                KVPair READKEY = SimpleJSON.parse(str, pointer, true);
                for (pointer = Integer.parseInt(READKEY.getKey()); pointer < LEN && SimpleJSON.containsChar(WHITESPACES, str.charAt(pointer)); ++pointer) {
                }
                try {
                    if (str.charAt(pointer) != ':') {
                        throw new IllegalArgumentException("expect ':' after key");
                    }
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("expect ':' after key");
                }
                if (++pointer >= LEN) {
                    throw new IllegalArgumentException("expect value");
                }
                KVPair READVALUE = SimpleJSON.parse(str, pointer, false);
                json.setProperty(READKEY.getValue(), READVALUE.getValue());
                for (pointer = Integer.parseInt(READVALUE.getKey()); pointer < LEN && SimpleJSON.containsChar(WHITESPACES, str.charAt(pointer)); ++pointer) {
                }
                try {
                    achar = str.charAt(pointer);
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("'{' was never closed");
                }
                if (achar == '}') {
                    return new KVPair(Integer.toString(pointer + 1), json);
                }
                if (achar != ',') {
                    throw new IllegalArgumentException("expect ',' after value");
                }
                ++pointer;
            }
            throw new IllegalArgumentException("'{' was never closed");
        }
        if (achar == '[' && !stringOnly) {
            SimpleJSON json = new SimpleJSON(new SimpleJSON[0]);
            int size = 0;
            ++pointer;
            while (pointer < LEN && SimpleJSON.containsChar(WHITESPACES, str.charAt(pointer))) {
                ++pointer;
            }
            try {
                if (str.charAt(pointer) == ']') {
                    return new KVPair(Integer.toString(pointer + 1), json);
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("'[' was never closed");
            }
            while (pointer < LEN) {
                KVPair READVALUE = SimpleJSON.parse(str, pointer, false);
                json.setProperty(size, READVALUE.getValue());
                ++size;
                for (pointer = Integer.parseInt(READVALUE.getKey()); pointer < LEN && SimpleJSON.containsChar(WHITESPACES, str.charAt(pointer)); ++pointer) {
                }
                try {
                    achar = str.charAt(pointer);
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("'[' was never closed");
                }
                if (achar == ']') {
                    return new KVPair(Integer.toString(pointer + 1), json);
                }
                if (achar != ',') {
                    throw new IllegalArgumentException("expect ',' after element");
                }
                ++pointer;
            }
            throw new IllegalArgumentException("'[' was never closed");
        }
        if (achar == NULL_IDENTIFIER.charAt(0) && !stringOnly) {
            try {
                int LEN2 = NULL_IDENTIFIER.length();
                if (str.substring(pointer, pointer + LEN2).equals(NULL_IDENTIFIER)) {
                    return new KVPair(Integer.toString(pointer + LEN2), null);
                }
            }
            catch (StringIndexOutOfBoundsException LEN2) {
                // empty catch block
            }
        }
        if (achar == FALSE_IDENTIFIER.charAt(0) && !stringOnly) {
            try {
                int LEN2 = FALSE_IDENTIFIER.length();
                if (str.substring(pointer, pointer + LEN2).equals(FALSE_IDENTIFIER)) {
                    return new KVPair(Integer.toString(pointer + LEN2), new SimpleJSON(false));
                }
            }
            catch (StringIndexOutOfBoundsException LEN2) {
                // empty catch block
            }
        }
        if (achar == TRUE_IDENTIFIER.charAt(0) && !stringOnly) {
            try {
                int LEN2 = TRUE_IDENTIFIER.length();
                if (str.substring(pointer, pointer + LEN2).equals(TRUE_IDENTIFIER)) {
                    return new KVPair(Integer.toString(pointer + LEN2), new SimpleJSON(true));
                }
            }
            catch (StringIndexOutOfBoundsException LEN2) {
                // empty catch block
            }
        }
        if (achar == '\"') {
            ++pointer;
            StringBuilder SB = new StringBuilder();
            while (pointer < LEN) {
                achar = str.charAt(pointer);
                if (achar == '\"') {
                    return new KVPair(Integer.toString(pointer + 1), new SimpleJSON(SB.toString()));
                }
                if (achar == '\\') {
                    ++pointer;
                    try {
                        achar = str.charAt(pointer);
                        if (!ESCAPE_RESULTS.containsKey(Character.valueOf(achar))) {
                            throw new IllegalArgumentException("invalid escape character");
                        }
                        String ESCAPE_RESULT = ESCAPE_RESULTS.get(Character.valueOf(achar));
                        if (ESCAPE_RESULT.length() == 0) {
                            if (!UNICODE_ESCAPE_VALUES.containsKey(Character.valueOf(achar = str.charAt(++pointer)))) {
                                throw new IllegalArgumentException("invalid u-escape character");
                            }
                            int cp = UNICODE_ESCAPE_VALUES.get(Character.valueOf(achar)).intValue() << 12;
                            if (!UNICODE_ESCAPE_VALUES.containsKey(Character.valueOf(achar = str.charAt(++pointer)))) {
                                throw new IllegalArgumentException("invalid u-escape character");
                            }
                            cp |= UNICODE_ESCAPE_VALUES.get(Character.valueOf(achar)).intValue() << 8;
                            if (!UNICODE_ESCAPE_VALUES.containsKey(Character.valueOf(achar = str.charAt(++pointer)))) {
                                throw new IllegalArgumentException("invalid u-escape character");
                            }
                            cp |= UNICODE_ESCAPE_VALUES.get(Character.valueOf(achar)).intValue() << 4;
                            if (!UNICODE_ESCAPE_VALUES.containsKey(Character.valueOf(achar = str.charAt(++pointer)))) {
                                throw new IllegalArgumentException("invalid u-escape character");
                            }
                            SB.append((char)(cp |= UNICODE_ESCAPE_VALUES.get(Character.valueOf(achar)).intValue()));
                        } else {
                            SB.append(ESCAPE_RESULT);
                        }
                        ++pointer;
                        continue;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("unterminated escape sequence");
                    }
                }
                if (SimpleJSON.containsChar(WHITESPACES, achar) && !SimpleJSON.containsChar(STRING_ALLOWED_WHITESPACES, achar)) {
                    throw new IllegalArgumentException("invalid whitespace in string literal");
                }
                SB.append(achar);
                ++pointer;
            }
            throw new IllegalArgumentException("'\"' was never closed");
        }
        if (!stringOnly) {
            int SP = pointer;
            achar = str.charAt(pointer);
            if (achar == '-') {
                ++pointer;
                try {
                    achar = str.charAt(pointer);
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IllegalArgumentException("expect digit");
                }
            }
            if (achar == '0') {
                ++pointer;
                try {
                    achar = str.charAt(pointer);
                }
                catch (StringIndexOutOfBoundsException e) {
                    return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP))));
                }
                if (achar == '.') {
                    ++pointer;
                    try {
                        achar = str.charAt(pointer);
                        if (!SimpleJSON.containsChar(DIGITS, achar)) {
                            throw new IllegalArgumentException("expect digit");
                        }
                        ++pointer;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("expect digit");
                    }
                    try {
                        while (SimpleJSON.containsChar(DIGITS, str.charAt(pointer))) {
                            ++pointer;
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP))));
                    }
                    achar = str.charAt(pointer);
                    if (!SimpleJSON.containsChar(EXPONENT, achar)) {
                        return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP, pointer))));
                    }
                    ++pointer;
                    try {
                        achar = str.charAt(pointer);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("expect digit, '+' or '-'");
                    }
                    if (achar != '+' && achar != '-' && !SimpleJSON.containsChar(DIGITS, achar)) {
                        throw new IllegalArgumentException("expect digit, '+' or '-'");
                    }
                    if (achar == '+' || achar == '-') {
                        ++pointer;
                        try {
                            achar = str.charAt(pointer);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("expect digit");
                        }
                    }
                    if (!SimpleJSON.containsChar(DIGITS, achar)) {
                        throw new IllegalArgumentException("expect digit");
                    }
                    ++pointer;
                    try {
                        while (SimpleJSON.containsChar(DIGITS, str.charAt(pointer))) {
                            ++pointer;
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP))));
                    }
                    return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP, pointer))));
                }
                if (SimpleJSON.containsChar(EXPONENT, achar)) {
                    ++pointer;
                    try {
                        achar = str.charAt(pointer);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("expect digit, '+' or '-'");
                    }
                    if (achar != '+' && achar != '-' && !SimpleJSON.containsChar(DIGITS, achar)) {
                        throw new IllegalArgumentException("expect digit, '+' or '-'");
                    }
                    if (achar == '+' || achar == '-') {
                        ++pointer;
                        try {
                            achar = str.charAt(pointer);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("expect digit");
                        }
                    }
                    if (!SimpleJSON.containsChar(DIGITS, achar)) {
                        throw new IllegalArgumentException("expect digit");
                    }
                    ++pointer;
                    try {
                        while (SimpleJSON.containsChar(DIGITS, str.charAt(pointer))) {
                            ++pointer;
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP))));
                    }
                    return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP, pointer))));
                }
                return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP, pointer))));
            }
            if (SimpleJSON.containsChar(DIGITS, achar)) {
                ++pointer;
                try {
                    while (SimpleJSON.containsChar(DIGITS, str.charAt(pointer))) {
                        ++pointer;
                    }
                }
                catch (StringIndexOutOfBoundsException e) {
                    return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP))));
                }
                achar = str.charAt(pointer);
                if (achar == '.') {
                    ++pointer;
                    try {
                        achar = str.charAt(pointer);
                        if (!SimpleJSON.containsChar(DIGITS, achar)) {
                            throw new IllegalArgumentException("expect digit");
                        }
                        ++pointer;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("expect digit");
                    }
                    try {
                        while (SimpleJSON.containsChar(DIGITS, str.charAt(pointer))) {
                            ++pointer;
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP))));
                    }
                    achar = str.charAt(pointer);
                    if (!SimpleJSON.containsChar(EXPONENT, achar)) {
                        return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP, pointer))));
                    }
                    ++pointer;
                    try {
                        achar = str.charAt(pointer);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("expect digit, '+' or '-'");
                    }
                    if (achar != '+' && achar != '-' && !SimpleJSON.containsChar(DIGITS, achar)) {
                        throw new IllegalArgumentException("expect digit, '+' or '-'");
                    }
                    if (achar == '+' || achar == '-') {
                        ++pointer;
                        try {
                            achar = str.charAt(pointer);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("expect digit");
                        }
                    }
                    if (!SimpleJSON.containsChar(DIGITS, achar)) {
                        throw new IllegalArgumentException("expect digit");
                    }
                    ++pointer;
                    try {
                        while (SimpleJSON.containsChar(DIGITS, str.charAt(pointer))) {
                            ++pointer;
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP))));
                    }
                    return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP, pointer))));
                }
                if (SimpleJSON.containsChar(EXPONENT, achar)) {
                    ++pointer;
                    try {
                        achar = str.charAt(pointer);
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("expect digit, '+' or '-'");
                    }
                    if (achar != '+' && achar != '-' && !SimpleJSON.containsChar(DIGITS, achar)) {
                        throw new IllegalArgumentException("expect digit, '+' or '-'");
                    }
                    if (achar == '+' || achar == '-') {
                        ++pointer;
                        try {
                            achar = str.charAt(pointer);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            throw new IllegalArgumentException("expect digit");
                        }
                    }
                    if (!SimpleJSON.containsChar(DIGITS, achar)) {
                        throw new IllegalArgumentException("expect digit");
                    }
                    ++pointer;
                    try {
                        while (SimpleJSON.containsChar(DIGITS, str.charAt(pointer))) {
                            ++pointer;
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP))));
                    }
                    return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP, pointer))));
                }
                return new KVPair(Integer.toString(pointer), new SimpleJSON(new BigDecimal(str.substring(SP, pointer))));
            }
        }
        throw new IllegalArgumentException(stringOnly ? "expect '\"'" : "invalid token");
    }

    @Contract(pure=true)
    public SimpleJSON(long num) {
        this.type = JSONType.NUMBER;
        this.content = Long.toString(num);
        this.ifArray = null;
        this.ifObject = null;
    }

    public SimpleJSON(double num) throws IllegalArgumentException {
        if (num == Double.POSITIVE_INFINITY || num == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("Infinity values are not accepted in JSON");
        }
        if (num != num) {
            throw new IllegalArgumentException("NaN is not accepted in JSON");
        }
        this.type = JSONType.NUMBER;
        this.content = Double.toString(num);
        this.ifArray = null;
        this.ifObject = null;
    }

    @Contract(pure=true)
    public SimpleJSON(@Nullable BigDecimal num) {
        this.type = num == null ? JSONType.NULL : JSONType.NUMBER;
        this.content = num == null ? null : num.toString();
        this.ifArray = null;
        this.ifObject = null;
    }

    @Contract(pure=true)
    public SimpleJSON(@Nullable String str) {
        this.type = str == null ? JSONType.NULL : JSONType.STRING;
        this.content = str;
        this.ifArray = null;
        this.ifObject = null;
    }

    @Contract(pure=true)
    public SimpleJSON(boolean bl) {
        this.type = JSONType.BOOLEAN;
        this.content = bl ? "" : null;
        this.ifArray = null;
        this.ifObject = null;
    }

    @Contract(pure=true)
    public SimpleJSON(SimpleJSON ... arr) {
        if (arr == null) {
            this.type = JSONType.NULL;
            this.content = null;
            this.ifArray = null;
            this.ifObject = null;
        } else {
            this.type = JSONType.ARRAY;
            this.content = null;
            this.ifArray = new ArrayList(arr.length);
            this.ifObject = null;
            for (SimpleJSON i : arr) {
                this.ifArray.add(i == null ? new SimpleJSON((String)null) : i);
            }
        }
    }

    public SimpleJSON(@Nullable Iterable<? extends SimpleJSON> arr) {
        if (arr == null) {
            this.type = JSONType.NULL;
            this.content = null;
            this.ifArray = null;
            this.ifObject = null;
        } else {
            this.type = JSONType.ARRAY;
            this.content = null;
            this.ifArray = new ArrayList();
            this.ifObject = null;
            for (SimpleJSON simpleJSON : arr) {
                this.ifArray.add(simpleJSON == null ? new SimpleJSON((String)null) : simpleJSON);
            }
        }
    }

    public SimpleJSON(Map.Entry<?, ? extends SimpleJSON> ... obj) throws NullPointerException {
        if (obj == null) {
            this.type = JSONType.NULL;
            this.content = null;
            this.ifArray = null;
            this.ifObject = null;
        } else {
            this.type = JSONType.OBJECT;
            this.content = null;
            this.ifArray = null;
            this.ifObject = new ArrayList();
            for (Map.Entry<?, SimpleJSON> entry : obj) {
                Object KEY = entry.getKey();
                String SKEY = KEY == null ? null : KEY.toString();
                SimpleJSON VAL = entry.getValue();
                int SIZE = this.ifObject.size();
                for (int j = 0; j < SIZE; ++j) {
                    if (!this.ifObject.get(j).getKey().equals(SKEY)) continue;
                    this.ifObject.remove(j);
                    break;
                }
                this.ifObject.add(new KVPair(SKEY, VAL));
            }
        }
    }

    public SimpleJSON(@Nullable Map<?, ? extends SimpleJSON> obj) {
        if (obj == null) {
            this.type = JSONType.NULL;
            this.content = null;
            this.ifArray = null;
            this.ifObject = null;
        } else {
            this.type = JSONType.OBJECT;
            this.content = null;
            this.ifArray = null;
            this.ifObject = new ArrayList();
            for (Map.Entry<?, SimpleJSON> i : obj.entrySet()) {
                Object KEY = i.getKey();
                String SKEY = KEY == null ? null : KEY.toString();
                this.ifObject.add(new KVPair(SKEY, i.getValue()));
            }
        }
    }

    @Contract(pure=true)
    public boolean isNull() {
        return this.type == null || this.type == JSONType.NULL;
    }

    @Contract(pure=true)
    public String toString() {
        if (this.isNull()) {
            return NULL_IDENTIFIER;
        }
        switch (this.type.ordinal()) {
            case 0: {
                return this.content;
            }
            case 1: {
                String body = this.content.replace("\\", "\\\\").replace("\"", "\\\"");
                for (char i : WHITESPACES.toCharArray()) {
                    if (SimpleJSON.containsChar(STRING_ALLOWED_WHITESPACES, i)) continue;
                    body = body.replace(String.valueOf(i), String.format("\\u%04x", i));
                }
                return "\"" + body + "\"";
            }
            case 2: {
                return this.content == null ? FALSE_IDENTIFIER : TRUE_IDENTIFIER;
            }
            case 3: {
                if (this.ifArray.isEmpty()) {
                    return "[]";
                }
                StringBuilder SB = new StringBuilder();
                SB.append('[');
                boolean firstPassed = false;
                for (SimpleJSON i : this.ifArray) {
                    if (firstPassed) {
                        SB.append(", ");
                    }
                    SB.append(i.toString());
                    firstPassed = true;
                }
                SB.append(']');
                return SB.toString();
            }
            case 4: {
                if (this.ifObject.isEmpty()) {
                    return "{}";
                }
                StringBuilder SB = new StringBuilder();
                SB.append('{');
                boolean firstPassed = false;
                for (KVPair i : this.ifObject) {
                    if (firstPassed) {
                        SB.append(", ");
                    }
                    SB.append('\"');
                    SB.append(i.getKey().replace("\\", "\\\\").replace("\"", "\\\""));
                    SB.append('\"');
                    SB.append(": ");
                    SB.append(i.getValue().toString());
                    firstPassed = true;
                }
                SB.append('}');
                return SB.toString();
            }
        }
        return "";
    }

    @Contract(value="null -> false", pure=true)
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleJSON)) {
            return false;
        }
        SimpleJSON that = (SimpleJSON)obj;
        if (this.isNull()) {
            return that.isNull();
        }
        if (this.type != that.type) {
            return false;
        }
        switch (this.type.ordinal()) {
            case 0: {
                return new BigDecimal(this.content).compareTo(new BigDecimal(that.content)) == 0;
            }
            case 1: {
                return this.content.equals(that.content);
            }
            case 2: {
                return this.content == null == (that.content == null);
            }
            case 3: {
                return this.ifArray.equals(that.ifArray);
            }
            case 4: {
                return this.ifObject.equals(that.ifObject);
            }
        }
        return false;
    }

    @Contract(pure=true)
    public int hashCode() {
        return (this.type == null ? JSONType.NULL : this.type).hashCode() ^ (this.content == null ? 0 : this.content.hashCode()) ^ (this.ifArray == null ? 0 : this.ifArray.hashCode()) ^ (this.ifObject == null ? 0 : this.ifObject.hashCode());
    }

    public BigDecimal getAsNumber() throws IllegalArgumentException {
        if (this.type != JSONType.NUMBER) {
            throw new IllegalArgumentException("JSON is not as number");
        }
        return new BigDecimal(this.content);
    }

    public String getAsString() throws IllegalArgumentException {
        if (this.type != JSONType.STRING) {
            throw new IllegalArgumentException("JSON is not as string");
        }
        return this.content;
    }

    public boolean getAsBoolean() throws IllegalArgumentException {
        if (this.type != JSONType.BOOLEAN) {
            throw new IllegalArgumentException("JSON is not as boolean");
        }
        return this.content != null;
    }

    @Nullable
    public SimpleJSON getProperty(Object sub) throws IllegalArgumentException {
        SimpleJSON JSON;
        if (this.isNull()) {
            throw new IllegalArgumentException("Cannot read properties of null");
        }
        if (sub instanceof SimpleJSON && !(JSON = (SimpleJSON)sub).isNull()) {
            switch (JSON.type.ordinal()) {
                case 0: {
                    sub = JSON.getAsNumber().stripTrailingZeros().toPlainString();
                    break;
                }
                case 1: {
                    sub = JSON.getAsString();
                }
            }
        }
        switch (this.type.ordinal()) {
            case 1: {
                BigInteger BI2;
                try {
                    BI2 = new BigInteger(sub.toString());
                    if (BI2.compareTo(BigInteger.ZERO) >= 0 && BI2.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
                        return new SimpleJSON(String.valueOf(this.content.charAt(BI2.intValue())));
                    }
                }
                catch (NumberFormatException BI2) {
                }
                catch (ArithmeticException BI2) {
                }
                catch (StringIndexOutOfBoundsException BI2) {
                    // empty catch block
                }
                return null;
            }
            case 3: {
                BigInteger BI2;
                try {
                    BI2 = new BigInteger(sub.toString());
                    if (BI2.compareTo(BigInteger.ZERO) >= 0 && BI2.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
                        return this.ifArray.get(BI2.intValue());
                    }
                }
                catch (NumberFormatException BI) {
                }
                catch (ArithmeticException BI) {
                }
                catch (StringIndexOutOfBoundsException BI) {
                    // empty catch block
                }
                return null;
            }
            case 4: {
                String STR = sub == null ? NULL_IDENTIFIER : sub.toString();
                for (KVPair i : this.ifObject) {
                    if (!i.getKey().equals(STR)) continue;
                    return i.getValue();
                }
                return null;
            }
        }
        return null;
    }

    public boolean setProperty(Object sub, SimpleJSON json) throws IllegalArgumentException {
        SimpleJSON JSON;
        if (this.isNull()) {
            throw new IllegalArgumentException("Cannot set properties of null");
        }
        if (sub instanceof SimpleJSON && !(JSON = (SimpleJSON)sub).isNull()) {
            switch (JSON.type.ordinal()) {
                case 0: {
                    sub = JSON.getAsNumber().stripTrailingZeros().toPlainString();
                    break;
                }
                case 1: {
                    sub = JSON.getAsString();
                }
            }
        }
        switch (this.type.ordinal()) {
            case 3: {
                try {
                    BigInteger BI = new BigInteger(sub.toString());
                    if (BI.compareTo(BigInteger.ZERO) >= 0 && BI.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
                        int INDEX = BI.intValue();
                        for (int size = this.ifArray.size(); size <= INDEX; ++size) {
                            this.ifArray.add(new SimpleJSON((String)null));
                        }
                        if (INDEX >= 0) {
                            this.ifArray.set(INDEX, json == null ? new SimpleJSON((String)null) : json);
                            return true;
                        }
                    }
                }
                catch (NumberFormatException BI) {
                }
                catch (ArithmeticException BI) {
                }
                catch (StringIndexOutOfBoundsException BI) {
                    // empty catch block
                }
                return false;
            }
            case 4: {
                String STR = sub == null ? NULL_IDENTIFIER : sub.toString();
                for (KVPair i : this.ifObject) {
                    if (!i.getKey().equals(STR)) continue;
                    i.setValue(json);
                    return true;
                }
                this.ifObject.add(new KVPair(STR, json));
                return true;
            }
        }
        return false;
    }

    public boolean deleteProperty(Object sub) throws IllegalArgumentException {
        SimpleJSON JSON;
        if (this.isNull()) {
            throw new IllegalArgumentException("Cannot set properties of null");
        }
        if (sub instanceof SimpleJSON && !(JSON = (SimpleJSON)sub).isNull()) {
            switch (JSON.type.ordinal()) {
                case 0: {
                    sub = JSON.getAsNumber().stripTrailingZeros().toPlainString();
                    break;
                }
                case 1: {
                    sub = JSON.getAsString();
                }
            }
        }
        switch (this.type.ordinal()) {
            case 3: {
                try {
                    BigInteger BI = new BigInteger(sub.toString());
                    if (BI.compareTo(BigInteger.ZERO) >= 0 && BI.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
                        int INDEX = BI.intValue();
                        this.ifArray.remove(INDEX);
                        return true;
                    }
                }
                catch (NumberFormatException BI) {
                }
                catch (ArithmeticException BI) {
                }
                catch (StringIndexOutOfBoundsException BI) {
                }
                catch (IndexOutOfBoundsException BI) {
                    // empty catch block
                }
                return false;
            }
            case 4: {
                String STR = sub == null ? NULL_IDENTIFIER : sub.toString();
                int index = 0;
                for (KVPair i : this.ifObject) {
                    if (i.getKey().equals(STR)) {
                        this.ifObject.remove(index);
                        return true;
                    }
                    ++index;
                }
                return false;
            }
        }
        return false;
    }

    @Nullable
    public Integer length() throws IllegalArgumentException {
        if (this.isNull()) {
            throw new IllegalArgumentException("Cannot read properties of null");
        }
        switch (this.type.ordinal()) {
            case 1: {
                return this.content.length();
            }
            case 3: {
                return this.ifArray.size();
            }
            case 4: {
                return this.ifObject.size();
            }
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public ArrayList<SimpleJSON> toList() {
        if (this.isNull()) {
            return null;
        }
        switch (this.type.ordinal()) {
            case 1: {
                ArrayList<SimpleJSON> RES = new ArrayList<SimpleJSON>();
                for (char i : this.content.toCharArray()) {
                    RES.add(new SimpleJSON(String.valueOf(i)));
                }
                return RES;
            }
            case 3: {
                return new ArrayList<SimpleJSON>(this.ifArray);
            }
            case 4: {
                ArrayList<SimpleJSON> RES = new ArrayList<SimpleJSON>();
                for (KVPair i : this.ifObject) {
                    RES.add(new SimpleJSON(i.getKey()));
                }
                return RES;
            }
        }
        return null;
    }

    public ArrayList<String> getKeys() throws IllegalArgumentException {
        if (this.type != JSONType.OBJECT) {
            throw new IllegalArgumentException("JSON is not as object");
        }
        ArrayList<String> RES = new ArrayList<String>();
        for (KVPair i : this.ifObject) {
            RES.add(i.getKey());
        }
        return RES;
    }

    public ArrayList<SimpleJSON> getValues() throws IllegalArgumentException {
        if (this.type != JSONType.OBJECT) {
            throw new IllegalArgumentException("JSON is not as object");
        }
        ArrayList<SimpleJSON> RES = new ArrayList<SimpleJSON>();
        for (KVPair i : this.ifObject) {
            RES.add(i.getValue());
        }
        return RES;
    }

    static {
        ESCAPE_RESULTS.put(Character.valueOf('b'), "\b");
        ESCAPE_RESULTS.put(Character.valueOf('f'), "\f");
        ESCAPE_RESULTS.put(Character.valueOf('n'), "\n");
        ESCAPE_RESULTS.put(Character.valueOf('r'), "\r");
        ESCAPE_RESULTS.put(Character.valueOf('t'), "\t");
        ESCAPE_RESULTS.put(Character.valueOf('u'), "");
        ESCAPE_RESULTS.put(Character.valueOf('/'), "/");
        ESCAPE_RESULTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_RESULTS.put(Character.valueOf('\"'), "\"");
        UNICODE_ESCAPE_VALUES = new HashMap();
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('0'), (byte)0);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('1'), (byte)1);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('2'), (byte)2);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('3'), (byte)3);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('4'), (byte)4);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('5'), (byte)5);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('6'), (byte)6);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('7'), (byte)7);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('8'), (byte)8);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('9'), (byte)9);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('A'), (byte)10);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('B'), (byte)11);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('C'), (byte)12);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('D'), (byte)13);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('E'), (byte)14);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('F'), (byte)15);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('a'), (byte)10);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('b'), (byte)11);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('c'), (byte)12);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('d'), (byte)13);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('e'), (byte)14);
        UNICODE_ESCAPE_VALUES.put(Character.valueOf('f'), (byte)15);
    }

    public static class KVPair
    implements Map.Entry<String, SimpleJSON> {
        @NotNull
        public final String key;
        @NotNull
        private SimpleJSON val;

        @Contract(pure=true)
        public KVPair(@Nullable String key, @Nullable SimpleJSON val) {
            this.key = key == null ? SimpleJSON.NULL_IDENTIFIER : key;
            this.val = val == null ? new SimpleJSON((String)null) : val;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public String getKey() {
            return this.key;
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public SimpleJSON getValue() {
            return this.val;
        }

        @Override
        @Contract(pure=false)
        @NotNull
        public SimpleJSON setValue(@Nullable SimpleJSON value) {
            SimpleJSON RES = this.val;
            this.val = value == null ? new SimpleJSON((String)null) : value;
            return RES;
        }
    }

    public static enum JSONType {
        NUMBER,
        STRING,
        BOOLEAN,
        ARRAY,
        OBJECT,
        NULL;

    }
}

