package rege.rege.minecraftmod.customsavedirs;

import java.io.File;
import java.io.FileReader;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_102;
import net.minecraft.class_94;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rege.rege.misc.customsavedirs.cc0fork.SimpleJSON;

public class CustomSaveDirsMain implements ClientModInitializer {
    public static final ArrayList<String> SAVE_DIRS = new ArrayList<>();
    private static final HashMap<String, class_102>
    CACHED_LEVEL_STORAGES = new HashMap<>();
    public static final Logger LOGGER =
    Logger.getLogger(CustomSaveDirsMain.class.getName());
    public static final String CONFIGURE_SAVE_DIRECTORIES_KEY =
    "options.savedirs";

    public static @Nullable RuntimeException validate(@NotNull String path) {
        try {
            FileSystems.getDefault().getPath(path);
        } catch (RuntimeException e) {
            return e;
        }
        return null;
    }

    public static void createLevelStoragesToCache() {
        for (String i : SAVE_DIRS) {
            try {
                CACHED_LEVEL_STORAGES.put(i, new class_94(
                    new File(i)
                ));
            } catch (IOError e) {
                LOGGER.log(
                    Level.SEVERE,
                    "Unable to cache level storage of " + i +
                    " due to an OS-level IO error", e
                );
            }
        }
    }

    public static void cleanUpCachedLevelStorages() {
        for (String i : new HashSet<>(CACHED_LEVEL_STORAGES.keySet())) {
            if (!SAVE_DIRS.contains(i)) {
                CACHED_LEVEL_STORAGES.remove(i);
            }
        }
    }

    @Contract(pure = true)
    public static @Nullable class_102
    getCachedLevelStorages(@NotNull String path) {
        return CACHED_LEVEL_STORAGES.get(path);
    }

    public static void loadConfig(@NotNull File configFile) {
        if (configFile.isFile()) {
            try {
                final FileReader FR = new FileReader(configFile);
                final StringBuilder SB = new StringBuilder();
                int ach;
                while ((ach = FR.read()) != -1) {
                    SB.append((char)ach);
                }
                FR.close();
                final SimpleJSON JE = SimpleJSON.parseJSON(SB.toString());
                SAVE_DIRS.clear();
                if (JE.type == SimpleJSON.JSONType.ARRAY) {
                    for (SimpleJSON i : JE.toList()) {
                        final String STR =
                        (i.type == SimpleJSON.JSONType.STRING) ?
                        i.getAsString() : i.toString();
                        final RuntimeException VALIDATION = validate(STR);
                        if (VALIDATION == null) {
                            SAVE_DIRS.add(STR);
                        } else {
                            LOGGER.log(
                                Level.WARNING,
                                "Will not load directory " + STR, VALIDATION
                            );
                        }
                    }
                }
                LOGGER.info(
                    "Loaded these directories from config/customsavedirs.json:"
                );
                for (String i : SAVE_DIRS) {
                    LOGGER.info(i);
                }
            } catch (IOException e) {
                LOGGER.warning(
                    "Failed to read file config/customsavedirs.json"
                );
            } catch (RuntimeException e) {
                LOGGER.log(
                    Level.SEVERE, "Error loading config/customsavedirs.json", e
                );
            }
        } else {
            LOGGER.info("Normal file config/customsavedirs.json not found.");
            LOGGER.info("Now use default save directory.");
        }
    }

    static {
        loadConfig(new File("config/customsavedirs.json"));
        cleanUpCachedLevelStorages();
    }

    @Override
    @Contract(pure = true)
    public void onInitializeClient() {}
}
