package rege.rege.minecraftmod.customsavedirs.gui.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.class_244;
import net.minecraft.class_356;
import net.minecraft.class_388;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.lwjgl.Sys;

import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain.*;
import static rege.rege.minecraftmod.customsavedirs.text.I18nHelper.translateOrFallback;

public class CustomSaveDirsScreen extends class_388 {
    public static final int CONFIGURE_SAVE_DIRECTORIES_BUTTON_ID = 123595003;
    public static final int CURRENT_DIR_BUTTON_ID = 923722340;
    public static final int EDIT_FILE_BUTTON_ID = 878847879;
    public static final int LOAD_FILE_BUTTON_ID = 488411916;
    public static final int DONE_BUTTON_ID = 309638920;
    public static final Logger LOGGER =
    Logger.getLogger(CustomSaveDirsScreen.class.getName());
    private static @Range(from = 0, to = Integer.MAX_VALUE) int CURRENT_DIR =0;
    public static final String TITLE_KEY = "options.savedirs.title";
    public static final String EDIT_FILE_KEY = "options.savedirs.editfile";
    public static final String LOAD_FILE_KEY = "options.savedirs.loadfile";
    public static final String EDIT_FILE_TOOLTIP_KEY =
    "options.savedirs.editfile.tooltip";
    public static final String LOAD_FILE_TOOLTIP_KEY =
    "options.savedirs.loadfile.tooltip";
    public static final String CURRENT_DIR_TOOLTIP_KEY =
    "options.savedirs.current.tooltip";
    public static final String CURRENT_UNAVAIL_DIR_TOOLTIP_KEY =
    "options.savedirs.current.unavailable.tooltip";

    @Contract(pure = true)
    public static @Range(from = 0, to = Integer.MAX_VALUE) int getCurrentDir(){
        return CURRENT_DIR;
    }

    public static @Range(from = 0, to = Integer.MAX_VALUE) int
    setCurrentDir(@Range(from = 0, to = Integer.MAX_VALUE) int currentDir) {
        if (currentDir < 0) {
            throw new IllegalArgumentException();
        }
        final int RES = CURRENT_DIR;
        CURRENT_DIR = SAVE_DIRS.isEmpty() ? 0 :(currentDir % SAVE_DIRS.size());
        return RES;
    }

    public static String textProvider() {
        setCurrentDir(getCurrentDir());
        if (SAVE_DIRS.isEmpty()) {
            return translateOrFallback(
                "options.savedirs.current", "Current"
            ) + ": " + class_244.method_630().method_635("generator.default");
        }
        final String DIR_PTH = SAVE_DIRS.get(getCurrentDir());
        return ((getCachedLevelStorages(DIR_PTH) == null) ?
                translateOrFallback(
            "options.savedirs.current.unavailable", "Current (unavailable now)"
        ) : translateOrFallback(
            "options.savedirs.current", "Current"
        )) + ": " + getCurrentDir() + ": " + DIR_PTH;
    }

    public static @Nullable Process
    openFile(@NotNull String name, @Nullable Logger logger) {
        String osname = System.getProperty("os.name");
        if (osname != null) {
            osname = osname.toLowerCase();
            if (osname.contains("mac")) {
                try {
                    return Runtime.getRuntime().exec(
                        new String[]{"/usr/bin/open", name}
                    );
                } catch (IOException e) {
                    if (logger != null) {
                        logger.log(
                            Level.SEVERE, "Couldn't open file " + name, e
                        );
                    }
                }
            } else if (osname.contains("win") || osname.contains("react")) {
                try {
                    return Runtime.getRuntime().exec(String.format(
                        "cmd.exe /C start \"Open file\" \"%s\"", name
                    ));
                } catch (IOException e) {
                    if (logger != null) {
                        logger.log(
                            Level.SEVERE, "Couldn't open file " + name, e
                        );
                    }
                }
            } else if (osname.contains("linux") || osname.contains("bsd")) {
                try {
                    return Runtime.getRuntime().exec(
                        new String[]{"xdg-open", name}
                    );
                } catch (IOException e) {
                    if (logger != null) {
                        logger.log(
                            Level.SEVERE, "Couldn't open file " + name, e
                        );
                    }
                }
            }
        }
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Object desktop = clazz.getMethod("getDesktop").invoke(null);
            clazz.getMethod("open", File.class).invoke(desktop,new File(name));
        } catch (Throwable throwable) {
            if (logger != null) {
                LOGGER.log(Level.SEVERE, "Couldn't open file", throwable);
                LOGGER.info("Opening via system class!");
            }
            Sys.openURL("file://" + name);
        }
        return null;
    }

    public final class_356 currentDirButton;
    public final class_356 editFileButton;
    public final class_356 loadFileButton;
    private final class_388 parent;

    public CustomSaveDirsScreen(class_388 parent) {
        super();
        this.parent = parent;
        this.currentDirButton = new class_356(
            CURRENT_DIR_BUTTON_ID, this.field_1230 / 2 - 155, 40, 310, 20,
            textProvider()
        );
        this.editFileButton = new class_356(
            EDIT_FILE_BUTTON_ID, this.field_1230 / 2 - 155, 64, 310, 20,
            translateOrFallback(EDIT_FILE_KEY, "Edit customsavedirs.json")
        );
        this.loadFileButton = new class_356(
            LOAD_FILE_BUTTON_ID, this.field_1230 / 2 - 155, 88, 310, 20,
            translateOrFallback(LOAD_FILE_KEY, "Reload customsavedirs.json")
        );
    }

    @SuppressWarnings("unchecked")
    public static void draw(@NotNull CustomSaveDirsScreen scr) {
        scr.currentDirButton.field_1051 = scr.field_1230 / 2 - 155;
        scr.editFileButton.field_1051 = scr.field_1230 / 2 - 155;
        scr.loadFileButton.field_1051 = scr.field_1230 / 2 - 155;
        scr.field_1232.add(scr.currentDirButton);
        scr.field_1232.add(scr.editFileButton);
        scr.field_1232.add(scr.loadFileButton);
        scr.field_1232.add(new class_356(
            DONE_BUTTON_ID, scr.field_1230 / 2 - 100, scr.field_1231 - 27, 200, 20,
            class_244.method_630().method_635("gui.done")
        ));
    }

    @Override
    public void method_1044() {
        this.field_1232.clear();
        CustomSaveDirsScreen.draw(this);
    }

    @Override
    public void method_1027(class_356 button) {
        if (button.field_1055) {
            if (button == this.currentDirButton) {
                setCurrentDir(getCurrentDir() + 1);
                button.field_1053 = textProvider();
                this.method_1044();
            } else if (button == this.editFileButton) {
                File file = new File("config");
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                file = new File(file, "customsavedirs.json");
                if (!file.isFile()) {
                    LOGGER.info(
                        "config/customsavedirs.json not exist, creating..."
                    );
                    try {
                        final FileWriter FW = new FileWriter(file);
                        FW.write("[]");
                        FW.close();
                    } catch (IOException e2) {
                        LOGGER.log(
                            Level.SEVERE,
                            "cannot create file config/customsavedirs.json", e2
                        );
                    }
                }
                openFile(new File(
                    "config/customsavedirs.json"
                ).getAbsolutePath(), LOGGER);
            } else if (button == this.loadFileButton) {
                loadConfig(new File("config/customsavedirs.json"));
                cleanUpCachedLevelStorages();
                if (CustomSaveDirsScreen.this.field_1229 != null) {
                    createLevelStoragesToCache();
                }
                CustomSaveDirsScreen.this.currentDirButton.field_1053 =
                textProvider();
            } else if (button.field_1054 == DONE_BUTTON_ID) {
                if (this.field_1229 != null) {
                    this.field_1229.method_2928(this.parent);
                }
            }
        }
    }

    @Override
    public void method_1025(int mouseX, int mouseY, float delta) {
        this.method_1043();
        if (this.field_1229 != null) {
            this.method_990(
                this.field_1229.field_3814,
                translateOrFallback(TITLE_KEY, "Save Directories"),
                this.field_1230 / 2, 15, 16777215
            );
        }
        super.method_1025(mouseX, mouseY, delta);
    }
}
