package rege.rege.minecraftmod.customsavedirs.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.jetbrains.annotations.Contract;
import rege.rege.minecraftmod.customsavedirs.gui.screen.CustomSaveDirsScreen;

import static rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain
              .CONFIGURE_SAVE_DIRECTORIES_KEY;
import static rege.rege.minecraftmod.customsavedirs.gui.widget
              .WidgetAutoLocator.getGriddedPackedLocation;
import static rege.rege.minecraftmod.customsavedirs.text.I18nHelper.translateOrFallback;

import net.minecraft.class_356;
import net.minecraft.class_388;

@Mixin(net.minecraft.class_383.class)
public abstract class AddConfigButtonMixin extends class_388 {
    @Contract("-> fail")
    protected AddConfigButtonMixin() {
        super();
        throw new AssertionError();
    }

    @SuppressWarnings("unchecked")
    @Inject(method = "init", at = @At(
        value = "INVOKE", target = "Ljava/util/List;add(Ljava/lang/Object;)Z",
        shift = At.Shift.AFTER, ordinal = 7
    ))
    private void addConfigButton(CallbackInfo info) {
        final long LOCATION = getGriddedPackedLocation(
            this.field_1232, 150, 20, this.field_1230 / 2 - 152,
            this.field_1231 / 6 + 96 - 6, 0, 2, 24, 154
        );
        if (LOCATION == -1L) {
            return;
        }
        this.field_1232.add(new class_356(
            CustomSaveDirsScreen.CONFIGURE_SAVE_DIRECTORIES_BUTTON_ID,
            (int)(LOCATION >>> 31L), (int)(LOCATION & 0x7fffffffL), 150, 20,
            translateOrFallback(
                CONFIGURE_SAVE_DIRECTORIES_KEY, "Configure Save Directories..."
            )
        ));
    }

    @Inject(method = "buttonClicked", at = @At("RETURN"))
    private void clickButton(class_356 par1, CallbackInfo info) {
        if (par1.field_1055 &&
            par1.field_1054 ==
            CustomSaveDirsScreen.CONFIGURE_SAVE_DIRECTORIES_BUTTON_ID) {
            if (this.field_1229 != null) {
                this.field_1229.field_3823.method_873();
                this.field_1229.method_2928(new CustomSaveDirsScreen(this));
            }
        }
    }
}
