/*
 * Decompiled with CFR 0.152.
 */
package rege.rege.minecraftmod.customsavedirs.gui.screen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.ButtonWidget;
import net.minecraft.client.resource.language.I18n;
import net.minecraft.client.sound.SoundManager;
import net.minecraft.text.LiteralText;
import net.minecraft.text.TranslatableText;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.lwjgl.Sys;
import rege.rege.minecraftmod.customsavedirs.CustomSaveDirsMain;
import rege.rege.minecraftmod.customsavedirs.text.I18nHelper;

public class CustomSaveDirsScreen
extends Screen {
    public static final int CONFIGURE_SAVE_DIRECTORIES_BUTTON_ID = 123595003;
    public static final int CURRENT_DIR_BUTTON_ID = 923722340;
    public static final int EDIT_FILE_BUTTON_ID = 878847879;
    public static final int LOAD_FILE_BUTTON_ID = 488411916;
    public static final int DONE_BUTTON_ID = 309638920;
    public static final Logger LOGGER = LogManager.getLogger((String)CustomSaveDirsScreen.class.getName());
    private static @Range(from=0L, to=0x7FFFFFFFL) int CURRENT_DIR = 0;
    public static final TranslatableText TITLE_TEXT = new TranslatableText("options.savedirs.title", new Object[0]);
    public static final TranslatableText EDIT_FILE_TEXT = new TranslatableText("options.savedirs.editfile", new Object[0]);
    public static final TranslatableText LOAD_FILE_TEXT = new TranslatableText("options.savedirs.loadfile", new Object[0]);
    public static final TranslatableText EDIT_FILE_TOOLTIP = new TranslatableText("options.savedirs.editfile.tooltip", new Object[]{FileSystems.getDefault().getPath("config/customsavedirs.json", new String[0]).toAbsolutePath().toString()});
    public static final TranslatableText LOAD_FILE_TOOLTIP = new TranslatableText("options.savedirs.loadfile.tooltip", new Object[0]);
    public static final TranslatableText CURRENT_DIR_TOOLTIP = new TranslatableText("options.savedirs.current.tooltip", new Object[0]);
    public final ButtonWidget currentDirButton;
    public final ButtonWidget editFileButton;
    public final ButtonWidget loadFileButton;
    private final Screen parent;

    public static @Range(from=0L, to=0x7FFFFFFFL) int getCurrentDir() {
        return CURRENT_DIR;
    }

    public static @Range(from=0L, to=0x7FFFFFFFL) int setCurrentDir(@Range(from=0L, to=0x7FFFFFFFL) int currentDir) {
        if (currentDir < 0) {
            throw new IllegalArgumentException();
        }
        int RES = CURRENT_DIR;
        CURRENT_DIR = CustomSaveDirsMain.SAVE_DIRS.isEmpty() ? 0 : currentDir % CustomSaveDirsMain.SAVE_DIRS.size();
        return RES;
    }

    public static String textProvider() {
        CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir());
        return I18nHelper.translateOrFallback("options.savedirs.current", "Current", new Object[0]) + ": " + (CustomSaveDirsMain.SAVE_DIRS.isEmpty() ? new TranslatableText("generator.default", new Object[0]) : new LiteralText(CustomSaveDirsScreen.getCurrentDir() + ": " + CustomSaveDirsMain.SAVE_DIRS.get(CustomSaveDirsScreen.getCurrentDir()))).computeValue();
    }

    @Nullable
    public static Process openFile(@NotNull String name, @Nullable Logger logger) {
        block15: {
            String osname = System.getProperty("os.name");
            if (osname != null) {
                if ((osname = osname.toLowerCase()).contains("mac")) {
                    try {
                        return Runtime.getRuntime().exec(new String[]{"/usr/bin/open", name});
                    }
                    catch (IOException e) {
                        if (logger != null) {
                            logger.error("Couldn't open file " + name, (Throwable)e);
                        }
                        break block15;
                    }
                }
                if (osname.contains("win") || osname.contains("react")) {
                    try {
                        return Runtime.getRuntime().exec(String.format("cmd.exe /C start \"Open file\" \"%s\"", name));
                    }
                    catch (IOException e) {
                        if (logger != null) {
                            logger.error("Couldn't open file " + name, (Throwable)e);
                        }
                        break block15;
                    }
                }
                if (osname.contains("linux") || osname.contains("bsd")) {
                    try {
                        return Runtime.getRuntime().exec(new String[]{"xdg-open", name});
                    }
                    catch (IOException e) {
                        if (logger == null) break block15;
                        logger.error("Couldn't open file " + name, (Throwable)e);
                    }
                }
            }
        }
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Object desktop = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            clazz.getMethod("open", File.class).invoke(desktop, new File(name));
        }
        catch (Throwable throwable) {
            if (logger != null) {
                LOGGER.error("Couldn't open file", throwable);
                LOGGER.info("Opening via system class!");
            }
            Sys.openURL((String)("file://" + name));
        }
        return null;
    }

    public CustomSaveDirsScreen(Screen parent) {
        this.parent = parent;
        this.currentDirButton = new ButtonWidget(923722340, this.width / 2 - 155, 40, 310, 20, CustomSaveDirsScreen.textProvider()){

            public void playDownSound(SoundManager soundManager) {
                CustomSaveDirsScreen.setCurrentDir(CustomSaveDirsScreen.getCurrentDir() + 1);
                this.message = CustomSaveDirsScreen.textProvider();
                CustomSaveDirsScreen.this.init();
                super.playDownSound(soundManager);
            }
        };
        this.editFileButton = new ButtonWidget(878847879, this.width / 2 - 155, 64, 310, 20, I18nHelper.translateOrFallback(EDIT_FILE_TEXT.getKey(), "Edit customsavedirs.json", new Object[0])){

            public void playDownSound(SoundManager soundManager) {
                File file = new File("config");
                if (!file.isDirectory()) {
                    file.mkdirs();
                }
                if (!(file = new File(file, "customsavedirs.json")).isFile()) {
                    LOGGER.info("config/customsavedirs.json not exist, creating...");
                    try {
                        FileWriter FW = new FileWriter(file);
                        FW.write("[]");
                        FW.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error("cannot create file config/customsavedirs.json", (Throwable)e2);
                    }
                }
                CustomSaveDirsScreen.openFile(new File("config/customsavedirs.json").getAbsolutePath(), LOGGER);
                super.playDownSound(soundManager);
            }
        };
        this.loadFileButton = new ButtonWidget(488411916, this.width / 2 - 155, 88, 310, 20, I18nHelper.translateOrFallback(LOAD_FILE_TEXT.getKey(), "Reload customsavedirs.json", new Object[0])){

            public void playDownSound(SoundManager soundManager) {
                CustomSaveDirsMain.loadConfig(new File("config/customsavedirs.json"));
                CustomSaveDirsMain.cleanUpCachedLevelStorages();
                if (CustomSaveDirsScreen.this.client != null) {
                    CustomSaveDirsMain.createLevelStoragesToCache();
                }
                CustomSaveDirsScreen.this.currentDirButton.message = CustomSaveDirsScreen.textProvider();
                super.playDownSound(soundManager);
            }
        };
    }

    public static void draw(final CustomSaveDirsScreen scr) {
        scr.currentDirButton.x = scr.width / 2 - 155;
        scr.editFileButton.x = scr.width / 2 - 155;
        scr.loadFileButton.x = scr.width / 2 - 155;
        scr.buttons.add(scr.currentDirButton);
        scr.buttons.add(scr.editFileButton);
        scr.buttons.add(scr.loadFileButton);
        scr.buttons.add(new ButtonWidget(309638920, scr.width / 2 - 100, scr.height - 27, 200, 20, I18n.translate((String)"gui.done", (Object[])new Object[0])){

            public void playDownSound(SoundManager soundManager) {
                if (scr.client != null) {
                    scr.client.setScreen(scr.parent);
                }
                super.playDownSound(soundManager);
            }
        });
    }

    public void init() {
        this.buttons.clear();
        CustomSaveDirsScreen.draw(this);
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.renderBackground();
        if (this.client != null) {
            this.drawCenteredString(this.client.textRenderer, I18nHelper.translateOrFallback(TITLE_TEXT.getKey(), "Save Directories", new Object[0]), this.width / 2, 15, 0xFFFFFF);
        }
        super.render(mouseX, mouseY, delta);
        if (this.currentDirButton != null && this.client != null && this.client.isIntegratedServerRunning() && this.currentDirButton.isHovered()) {
            this.renderTooltip(this.client.textRenderer.wrapLines(I18nHelper.translateOrFallback(CURRENT_DIR_TOOLTIP.getKey(), "This option will be applied after you save and exit the current world", new Object[0]), 200), mouseX, mouseY);
        }
        if (this.editFileButton != null && this.client != null && this.editFileButton.isHovered()) {
            this.renderTooltip(this.client.textRenderer.wrapLines(I18nHelper.translateOrFallback(EDIT_FILE_TOOLTIP.getKey(), "By clicking this button an editor will open. If not, please manually open %s", FileSystems.getDefault().getPath("config/customsavedirs.json", new String[0]).toAbsolutePath().toString()), 200), mouseX, mouseY);
        }
        if (this.loadFileButton != null && this.client != null && this.loadFileButton.isHovered()) {
            this.renderTooltip(this.client.textRenderer.wrapLines(I18nHelper.translateOrFallback(LOAD_FILE_TOOLTIP.getKey(), "The content of customsavedirs.json should be a valid JSON array with zero, one or multiple strings. These strings represent save directories.", new Object[0]), 200), mouseX, mouseY);
        }
    }
}

