/*
 * Decompiled with CFR 0.152.
 */
package com.copicraftDev.copis_bookmarks_mod;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Copis_bookmarks_mod
implements ModInitializer {
    public static final String MOD_ID = "copis_bookmarks_mod";
    private final Map<UUID, List<Bookmark>> bookmarks = new HashMap<UUID, List<Bookmark>>();
    private final Gson gson = new Gson();
    private final File saveFile = new File("config", "copis_bookmarks.json");
    private final int MAX_BOOKMARKS = 50;

    public void onInitialize() {
        this.loadBookmarks();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bookmark").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String desc;
            String name;
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            return this.addBookmark(player, name = StringArgumentType.getString((CommandContext)ctx, (String)"name"), desc = StringArgumentType.getString((CommandContext)ctx, (String)"description")) ? 1 : 0;
        }))))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            this.listBookmarks(player);
            return 1;
        }))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name;
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            return this.removeBookmark(player, name = StringArgumentType.getString((CommandContext)ctx, (String)"name")) ? 1 : 0;
        })))));
    }

    private boolean addBookmark(class_3222 player, String name, String description) {
        UUID uuid = player.method_5667();
        this.bookmarks.putIfAbsent(uuid, new ArrayList());
        List<Bookmark> list = this.bookmarks.get(uuid);
        if (list.size() >= 50) {
            player.method_7353(class_2561.method_30163((String)"\u00a7cYou have reached the maximum of 50 bookmarks."), false);
            return false;
        }
        list.add(new Bookmark(name, description, System.currentTimeMillis()));
        this.saveBookmarks();
        player.method_7353(class_2561.method_30163((String)("\u00a7aBookmark '" + name + "' added!")), false);
        return true;
    }

    private void listBookmarks(class_3222 player) {
        UUID uuid = player.method_5667();
        List list = this.bookmarks.getOrDefault(uuid, new ArrayList());
        if (list.isEmpty()) {
            player.method_7353(class_2561.method_30163((String)"\u00a7eYou have no bookmarks."), false);
            return;
        }
        player.method_7353(class_2561.method_30163((String)"\u00a76Your bookmarks:"), false);
        for (Bookmark b : list) {
            Date date = new Date(b.timestamp);
            player.method_7353(class_2561.method_30163((String)("\u00a7b" + b.name + " \u00a77- " + b.description + " \u00a78(" + String.valueOf(date) + ")")), false);
        }
    }

    private boolean removeBookmark(class_3222 player, String name) {
        UUID uuid = player.method_5667();
        List list = this.bookmarks.getOrDefault(uuid, new ArrayList());
        boolean removed = list.removeIf(b -> b.name.equalsIgnoreCase(name));
        if (removed) {
            this.saveBookmarks();
            player.method_7353(class_2561.method_30163((String)("\u00a7aBookmark '" + name + "' removed!")), false);
        } else {
            player.method_7353(class_2561.method_30163((String)("\u00a7cBookmark '" + name + "' not found.")), false);
        }
        return removed;
    }

    private void saveBookmarks() {
        try {
            if (!this.saveFile.getParentFile().exists()) {
                this.saveFile.getParentFile().mkdirs();
            }
            FileWriter writer = new FileWriter(this.saveFile);
            this.gson.toJson(this.bookmarks, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadBookmarks() {
        try {
            if (!this.saveFile.exists()) {
                return;
            }
            FileReader reader = new FileReader(this.saveFile);
            Type type = new TypeToken<Map<UUID, List<Bookmark>>>(this){}.getType();
            Map raw = (Map)this.gson.fromJson((Reader)reader, new TypeToken<Map<String, List<Bookmark>>>(this){}.getType());
            reader.close();
            if (raw != null) {
                raw.forEach((k, v) -> this.bookmarks.put(UUID.fromString(k), (List<Bookmark>)v));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Bookmark {
        String name;
        String description;
        long timestamp;

        public Bookmark(String name, String description, long timestamp) {
            this.name = name;
            this.description = description;
            this.timestamp = timestamp;
        }
    }
}

