/*
 * Decompiled with CFR 0.152.
 */
package com.copicraftDev.copisBookmarksPlugin;

import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public final class CopisBookmarksPlugin
extends JavaPlugin {
    private static final int MAX_BOOKMARKS = 50;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void onEnable() {
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.getLogger().info("CopisBookmarksPlugin v1.1 enabled!");
    }

    public void onDisable() {
        this.getLogger().info("CopisBookmarksPlugin disabled!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        File playerFile = new File(this.getDataFolder(), String.valueOf(player.getUniqueId()) + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
        if (command.getName().equalsIgnoreCase("bookmark")) {
            String sub;
            if (args.length == 0) {
                player.sendMessage("Usage: /bookmark <add|del|list|info> [name] [description]");
                return true;
            }
            switch (sub = args[0].toLowerCase()) {
                case "add": {
                    if (args.length < 2) {
                        player.sendMessage("Usage: /bookmark add <name> [description]");
                        return true;
                    }
                    Set keys = config.getKeys(false);
                    if (keys.size() >= 50) {
                        player.sendMessage("You reached the maximum of 50 bookmarks!");
                        return true;
                    }
                    String nameAdd = args[1];
                    String description = "";
                    if (args.length > 2) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 2; i < args.length; ++i) {
                            sb.append(args[i]).append(" ");
                        }
                        description = sb.toString().trim();
                    }
                    Location loc = player.getLocation();
                    config.set(nameAdd + ".world", (Object)loc.getWorld().getName());
                    config.set(nameAdd + ".x", (Object)loc.getBlockX());
                    config.set(nameAdd + ".y", (Object)loc.getBlockY());
                    config.set(nameAdd + ".z", (Object)loc.getBlockZ());
                    config.set(nameAdd + ".description", (Object)description);
                    config.set(nameAdd + ".timestamp", (Object)DATE_FORMAT.format(LocalDateTime.now()));
                    try {
                        config.save(playerFile);
                        player.sendMessage("Bookmark '" + nameAdd + "' saved! Description: " + (description.isEmpty() ? "None" : description));
                    }
                    catch (IOException e) {
                        player.sendMessage("Failed to save bookmark!");
                        e.printStackTrace();
                    }
                    break;
                }
                case "del": {
                    if (args.length < 2) {
                        player.sendMessage("Usage: /bookmark del <name>");
                        return true;
                    }
                    String nameDel = args[1];
                    if (config.contains(nameDel)) {
                        config.set(nameDel, null);
                        try {
                            config.save(playerFile);
                            player.sendMessage("Bookmark '" + nameDel + "' deleted!");
                        }
                        catch (IOException e) {
                            player.sendMessage("Failed to delete bookmark!");
                            e.printStackTrace();
                        }
                        break;
                    }
                    player.sendMessage("Bookmark '" + nameDel + "' not found!");
                    break;
                }
                case "list": {
                    Set keys = config.getKeys(false);
                    if (keys.isEmpty()) {
                        player.sendMessage("You have no bookmarks.");
                        break;
                    }
                    player.sendMessage("Your bookmarks (" + keys.size() + "/50):");
                    for (String key : keys) {
                        World w = Bukkit.getWorld((String)config.getString(key + ".world"));
                        int x = config.getInt(key + ".x");
                        int y = config.getInt(key + ".y");
                        int z = config.getInt(key + ".z");
                        String desc = config.getString(key + ".description", "None");
                        String time = config.getString(key + ".timestamp", "Unknown");
                        player.sendMessage(key + " \u2192 " + w.getName() + " [" + x + ", " + y + ", " + z + "] | Desc: " + desc + " | Added: " + time);
                    }
                    break;
                }
                case "info": {
                    if (args.length < 2) {
                        player.sendMessage("Usage: /bookmark info <name>");
                        return true;
                    }
                    String nameInfo = args[1];
                    if (config.contains(nameInfo)) {
                        World w = Bukkit.getWorld((String)config.getString(nameInfo + ".world"));
                        int x = config.getInt(nameInfo + ".x");
                        int y = config.getInt(nameInfo + ".y");
                        int z = config.getInt(nameInfo + ".z");
                        String desc = config.getString(nameInfo + ".description", "None");
                        String time = config.getString(nameInfo + ".timestamp", "Unknown");
                        player.sendMessage(nameInfo + " \u2192 " + w.getName() + " [" + x + ", " + y + ", " + z + "] | Desc: " + desc + " | Added: " + time);
                        break;
                    }
                    player.sendMessage("Bookmark '" + nameInfo + "' not found!");
                    break;
                }
                default: {
                    player.sendMessage("Unknown subcommand: " + sub);
                }
            }
            return true;
        }
        return false;
    }
}

