/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBlockStateModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.StaticBlockEntityTintGetter;
import org.joml.Quaternionfc;

public class StorageBlockRenderer {
    private static final Map<Class<? extends AbstractChestedHorse>, Function<StorageBlockEntity, Vec3>> OFFSET_MAP = new LinkedHashMap<Class<? extends AbstractChestedHorse>, Function<StorageBlockEntity, Vec3>>();
    public static final Vec3 DONKEY_CHEST_OFFSET = new Vec3(0.0, -0.26, -0.1);
    public static final Vec3 DONKEY_OTHER_OFFSET = new Vec3(0.0, -0.325, -0.07);
    public static final Vec3 MULE_CHEST_OFFSET = new Vec3(0.0, -0.18, -0.13);
    public static final Vec3 MULE_OTHER_OFFSET = new Vec3(0.0, -0.24, -0.1);
    public static final Vec3 LLAMA_OTHER_OFFSET = new Vec3(0.0, -0.02, 0.0);
    private static final Function<StorageBlockEntity, Vec3> DEFAULT_OFFSET;

    public static void submitStorageBlock(float partialTicks, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, StorageBlockEntity renderBlockEntity) {
        BlockEntityRenderer renderer;
        BlockState state = renderBlockEntity.getBlockState();
        Minecraft minecraft = Minecraft.getInstance();
        if (renderBlockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)renderBlockEntity;
            BlockRenderDispatcher blockRenderer = minecraft.getBlockRenderer();
            BlockStateModel blockStateModel = blockRenderer.getBlockModel(barrel.getBlockState());
            if (blockStateModel instanceof BarrelBlockStateModelBase) {
                BarrelBlockStateModelBase barrelModel = (BarrelBlockStateModelBase)blockStateModel;
                barrelModel.setModelPropertiesFromBlockEntity(barrel);
            }
            StaticBlockEntityTintGetter wrappedLevel = new StaticBlockEntityTintGetter((BlockAndTintGetter)minecraft.level, (BlockEntity)renderBlockEntity, packedLight);
            List parts = blockStateModel.collectParts((BlockAndTintGetter)wrappedLevel, BlockPos.ZERO, state, RandomSource.create((long)42L));
            ArrayList<BlockModelPart> translucentParts = new ArrayList<BlockModelPart>();
            Iterator it = parts.iterator();
            while (it.hasNext()) {
                BlockModelPart part = (BlockModelPart)it.next();
                if (part.getRenderType(barrel.getBlockState()) != ChunkSectionLayer.TRANSLUCENT) continue;
                translucentParts.add(part);
                it.remove();
            }
            submitNodeCollector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), (pose, vertexConsumer) -> {
                for (BlockModelPart part : parts) {
                    StorageBlockRenderer.renderBlockModelPart(packedLight, pose, vertexConsumer, part, state, wrappedLevel);
                }
            });
            if (!translucentParts.isEmpty()) {
                submitNodeCollector.submitCustomGeometry(poseStack, RenderTypeHelper.getEntityRenderType((ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT), (pose, vertexConsumer) -> {
                    for (BlockModelPart translucentPart : translucentParts) {
                        StorageBlockRenderer.renderBlockModelPart(packedLight, pose, vertexConsumer, translucentPart, state, wrappedLevel);
                    }
                });
            }
        }
        if ((renderer = minecraft.getBlockEntityRenderDispatcher().getRenderer((BlockEntity)renderBlockEntity)) == null) {
            return;
        }
        StorageBlockRenderer.submitBlockEntityRender(renderer, renderBlockEntity, partialTicks, poseStack, submitNodeCollector, packedLight);
    }

    private static void renderBlockModelPart(int packedLight, PoseStack.Pose pose, VertexConsumer vertexConsumer, BlockModelPart part, BlockState state, BlockAndTintGetter wrappedLevel) {
        for (Direction direction : Direction.values()) {
            StorageBlockRenderer.renderBlockModelPartQuads(packedLight, pose, vertexConsumer, part, direction, state, wrappedLevel);
        }
        StorageBlockRenderer.renderBlockModelPartQuads(packedLight, pose, vertexConsumer, part, null, state, wrappedLevel);
    }

    private static void renderBlockModelPartQuads(int packedLight, PoseStack.Pose pose, VertexConsumer vertexConsumer, BlockModelPart part, @Nullable Direction direction, BlockState state, BlockAndTintGetter wrappedLevel) {
        for (BakedQuad quad : part.getQuads(direction)) {
            float red = 1.0f;
            float green = 1.0f;
            float blue = 1.0f;
            if (quad.isTinted()) {
                int tint = Minecraft.getInstance().getBlockColors().getColor(state, wrappedLevel, BlockPos.ZERO, quad.tintIndex());
                red = ARGB.redFloat((int)tint);
                green = ARGB.greenFloat((int)tint);
                blue = ARGB.blueFloat((int)tint);
            }
            vertexConsumer.putBulkData(pose, quad, red, green, blue, 1.0f, packedLight, OverlayTexture.NO_OVERLAY, false);
        }
    }

    private static <T extends BlockEntity, S extends BlockEntityRenderState> void submitBlockEntityRender(BlockEntityRenderer<T, S> renderer, T blockEntity, float partialTicks, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight) {
        BlockEntityRenderState renderState = renderer.createRenderState();
        renderer.extractRenderState(blockEntity, renderState, partialTicks, Vec3.ZERO, null);
        renderState.lightCoords = packedLight;
        renderer.submit(renderState, poseStack, submitNodeCollector, RenderHelper.ZERO_POS_CAMERA_RENDER_STATE);
    }

    public static void submitChestedHorseStorage(Class<? extends AbstractChestedHorse> chestedHorseClass, EntityRenderState entityRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight, @Nullable StorageBlockEntity renderBlockEntity) {
        if (renderBlockEntity == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        Function<StorageBlockEntity, Vec3> offsetFunction = OFFSET_MAP.getOrDefault(chestedHorseClass, DEFAULT_OFFSET);
        if (offsetFunction != null) {
            poseStack.translate(offsetFunction.apply((StorageBlockEntity)renderBlockEntity).x, offsetFunction.apply((StorageBlockEntity)renderBlockEntity).y, offsetFunction.apply((StorageBlockEntity)renderBlockEntity).z);
        }
        StorageBlockRenderer.submitStorageOnSide(chestedHorseClass, entityRenderState, poseStack, 90, 1.0f, renderBlockEntity, packedLight, submitNodeCollector, entityRenderState.partialTick);
        StorageBlockRenderer.submitStorageOnSide(chestedHorseClass, entityRenderState, poseStack, 270, -1.0f, renderBlockEntity, packedLight, submitNodeCollector, entityRenderState.partialTick);
        poseStack.popPose();
    }

    private static void submitStorageOnSide(Class<? extends AbstractChestedHorse> chestedHorseClass, EntityRenderState entityRenderState, PoseStack poseStack, int storageRotation, float xOffsetMultiplier, StorageBlockEntity renderBlockEntity, int packedLight, SubmitNodeCollector submitNodeCollector, float partialTick) {
        float halfWidth = entityRenderState.boundingBoxWidth / 2.0f;
        poseStack.pushPose();
        float scale = Llama.class.isAssignableFrom(chestedHorseClass) ? 0.57f : 0.5f;
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees((float)storageRotation));
        float xOffset = halfWidth * -0.49f * xOffsetMultiplier;
        float sideOffset = Llama.class.isAssignableFrom(chestedHorseClass) ? (renderBlockEntity instanceof ChestBlockEntity ? 1.0f : 0.85f) : (renderBlockEntity instanceof ChestBlockEntity ? 0.6f : 0.5f);
        float zOffset = -halfWidth * sideOffset;
        double yOffset = -entityRenderState.boundingBoxHeight * 0.379f;
        poseStack.translate((double)xOffset, yOffset, (double)zOffset);
        if (!(renderBlockEntity instanceof ChestBlockEntity)) {
            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
        }
        poseStack.translate(-0.5, -0.5, -0.5);
        StorageBlockRenderer.submitStorageBlock(partialTick, poseStack, submitNodeCollector, packedLight, renderBlockEntity);
        poseStack.popPose();
    }

    static {
        OFFSET_MAP.put(Donkey.class, renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? DONKEY_CHEST_OFFSET : DONKEY_OTHER_OFFSET);
        OFFSET_MAP.put(Mule.class, renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? MULE_CHEST_OFFSET : MULE_OTHER_OFFSET);
        OFFSET_MAP.put(Llama.class, renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? Vec3.ZERO : LLAMA_OTHER_OFFSET);
        OFFSET_MAP.put(AbstractChestedHorse.class, renderBlockEntity -> MULE_OTHER_OFFSET);
        DEFAULT_OFFSET = renderBlockEntity -> renderBlockEntity instanceof ChestBlockEntity ? new Vec3(0.0, -1.343, -0.515) : new Vec3(0.0, -1.4, -0.48);
    }
}

