/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.MovingStorageItemRenderer;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageBoat;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.StorageBoatItem;

public class StorageBoatItemRenderer
extends MovingStorageItemRenderer<StorageBoat, BoatRenderData> {
    @Nullable
    public BoatRenderData extractArgument(ItemStack itemStack) {
        ItemStack storageItem = MovingStorageItem.getStorageItem((DataComponentHolder)itemStack);
        if (storageItem == ItemStack.EMPTY) {
            return new BoatRenderData(ItemStack.EMPTY, WoodType.ACACIA);
        }
        return new BoatRenderData(storageItem, StorageBoatItem.getWoodType(itemStack));
    }

    @Override
    protected void setMovingStoragePropertiesFromData(StorageBoat movingStorage, BoatRenderData data) {
        if (data != null) {
            movingStorage.setWoodType(data.woodType());
        }
    }

    @Override
    protected StorageBoat instantiateMovingStorage(Minecraft mc) {
        return new StorageBoat((Level)mc.level);
    }

    public static class BoatRenderData
    extends MovingStorageItemRenderer.RenderData {
        private final WoodType woodType;

        public BoatRenderData(ItemStack storageItem, WoodType woodType) {
            super(storageItem);
            this.woodType = woodType;
        }

        public WoodType woodType() {
            return this.woodType;
        }
    }

    public static class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)new Unbaked());

        @Nullable
        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext bakingContext) {
            return new StorageBoatItemRenderer();
        }

        public MapCodec<? extends Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

