/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.AbstractBoatRenderer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.BoatRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.ContextKeys;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.IMovingStorageRenderer;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.StorageBlockRenderer;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageBoat;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class StorageBoatRenderer
extends EntityRenderer<StorageBoat, BoatRenderState>
implements IMovingStorageRenderer {
    private final Map<WoodType, AbstractBoatRenderer> baseBoatRenderers;
    public static final BiConsumer<StorageBoat, BoatRenderState> RENDER_STATE_MODIFIER = (storageBoat, renderState) -> {
        renderState.setRenderData(ContextKeys.BASE_BOAT_WOOD_TYPE, (Object)storageBoat.getWoodType());
        renderState.setRenderData(ContextKeys.RENDER_BLOCK_ENTITY, (Object)storageBoat.getStorageHolder().getRenderBlockEntity());
    };

    public StorageBoatRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.baseBoatRenderers = Map.of(WoodType.ACACIA, new BoatRenderer(context, ModelLayers.ACACIA_BOAT), WoodType.BIRCH, new BoatRenderer(context, ModelLayers.BIRCH_BOAT), WoodType.CHERRY, new BoatRenderer(context, ModelLayers.CHERRY_BOAT), WoodType.DARK_OAK, new BoatRenderer(context, ModelLayers.DARK_OAK_BOAT), WoodType.JUNGLE, new BoatRenderer(context, ModelLayers.JUNGLE_BOAT), WoodType.MANGROVE, new BoatRenderer(context, ModelLayers.MANGROVE_BOAT), WoodType.OAK, new BoatRenderer(context, ModelLayers.OAK_BOAT), WoodType.PALE_OAK, new BoatRenderer(context, ModelLayers.PALE_OAK_BOAT), WoodType.SPRUCE, new BoatRenderer(context, ModelLayers.SPRUCE_BOAT), WoodType.BAMBOO, new BoatRenderer(context, ModelLayers.BAMBOO_RAFT));
    }

    public BoatRenderState createRenderState() {
        return new BoatRenderState();
    }

    public void extractRenderState(StorageBoat storageBoat, BoatRenderState boatRenderState, float partialTick) {
        super.extractRenderState((Entity)storageBoat, (EntityRenderState)boatRenderState, partialTick);
        boatRenderState.yRot = storageBoat.getYRot(partialTick);
        boatRenderState.hurtTime = (float)storageBoat.getHurtTime() - partialTick;
        boatRenderState.hurtDir = storageBoat.getHurtDir();
        boatRenderState.damageTime = Math.max(storageBoat.getDamage() - partialTick, 0.0f);
        boatRenderState.bubbleAngle = storageBoat.getBubbleAngle(partialTick);
        boatRenderState.isUnderWater = storageBoat.isUnderWater();
        boatRenderState.rowingTimeLeft = storageBoat.getRowingTime(0, partialTick);
        boatRenderState.rowingTimeRight = storageBoat.getRowingTime(1, partialTick);
    }

    public void submit(BoatRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        float bubbleAngle;
        super.submit((EntityRenderState)renderState, poseStack, submitNodeCollector, cameraRenderState);
        StorageBlockEntity renderBlockEntity = (StorageBlockEntity)renderState.getRenderData(ContextKeys.RENDER_BLOCK_ENTITY);
        WoodType woodType = (WoodType)renderState.getRenderData(ContextKeys.BASE_BOAT_WOOD_TYPE);
        if (renderBlockEntity == null || woodType == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, woodType == WoodType.BAMBOO ? 0.5f : 0.1875f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - renderState.yRot));
        float interpolatedHurtTime = renderState.hurtTime;
        float interpolatedDamage = renderState.damageTime;
        if (interpolatedDamage < 0.0f) {
            interpolatedDamage = 0.0f;
        }
        if (interpolatedHurtTime > 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.sin((float)interpolatedHurtTime) * interpolatedHurtTime * interpolatedDamage / 10.0f * (float)renderState.hurtDir));
        }
        if (!Mth.equal((float)(bubbleAngle = renderState.bubbleAngle), (float)0.0f)) {
            poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(renderState.bubbleAngle * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        poseStack.scale(0.85714287f, 0.85714287f, 0.85714287f);
        poseStack.translate(-0.5f, 0.0f, (renderBlockEntity instanceof BarrelBlockEntity || renderBlockEntity instanceof ShulkerBoxBlockEntity ? 0.0f : 0.0625f) + 0.02f);
        StorageBlockRenderer.submitStorageBlock(renderState.partialTick, poseStack, submitNodeCollector, renderState.lightCoords, renderBlockEntity);
        poseStack.popPose();
        this.baseBoatRenderers.get(woodType).submit(renderState, poseStack, submitNodeCollector, cameraRenderState);
    }

    @Override
    public ModelPart rootModelPart() {
        return ((BoatRenderer)this.baseBoatRenderers.get((Object)WoodType.OAK)).model.root();
    }
}

