/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BiConsumer;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.AbstractMinecartRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.MinecartRenderState;
import net.minecraft.world.level.block.state.BlockState;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.ContextKeys;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.IMovingStorageRenderer;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.StorageBlockRenderer;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.StorageMinecart;

public class StorageMinecartRenderer
extends AbstractMinecartRenderer<StorageMinecart, MinecartRenderState>
implements IMovingStorageRenderer {
    public static final BiConsumer<StorageMinecart, MinecartRenderState> RENDER_STATE_MODIFIER = (minecart, minecartRenderState) -> minecartRenderState.setRenderData(ContextKeys.RENDER_BLOCK_ENTITY, (Object)minecart.getStorageHolder().getRenderBlockEntity());

    public StorageMinecartRenderer(EntityRendererProvider.Context context) {
        super(context, ModelLayers.MINECART);
    }

    public MinecartRenderState createRenderState() {
        return new MinecartRenderState();
    }

    protected void submitMinecartContents(MinecartRenderState minecartRenderState, BlockState blockState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int packedLight) {
        StorageBlockEntity renderBlockEntity = (StorageBlockEntity)minecartRenderState.getRenderData(ContextKeys.RENDER_BLOCK_ENTITY);
        if (renderBlockEntity == null) {
            return;
        }
        poseStack.pushPose();
        double yOffset = 0.0;
        if (renderBlockEntity instanceof BarrelBlockEntity || renderBlockEntity instanceof ShulkerBoxBlockEntity) {
            yOffset -= 0.125;
        }
        poseStack.translate(0.0, yOffset, 0.0);
        StorageBlockRenderer.submitStorageBlock(minecartRenderState.partialTick, poseStack, submitNodeCollector, packedLight, renderBlockEntity);
        poseStack.popPose();
    }

    @Override
    public ModelPart rootModelPart() {
        return this.model.root();
    }
}

