/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.common.IItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageSyncItemHighlightsPayload;

public class MovingStorageItemActionPayloadHandler
implements IItemActionPayloadHandler<List<Integer>> {
    public static MovingStorageItemActionPayloadHandler INSTANCE = new MovingStorageItemActionPayloadHandler();
    public static final ResourceLocation ID = SophisticatedStorageInMotion.getRL("moving_storage_item_action");

    private MovingStorageItemActionPayloadHandler() {
    }

    public ResourceLocation id() {
        return ID;
    }

    public StreamCodec<ByteBuf, List<Integer>> codec() {
        return ByteBufCodecs.INT.apply(ByteBufCodecs.list());
    }

    public IItemActionPayloadHandler.HighlightResult computeHighlight(ServerPlayer player, ItemStackKey stackKey, List<Integer> clientData) {
        ArrayList<Integer> entitiesWithStack = new ArrayList<Integer>();
        ArrayList<Integer> entitiesWithItem = new ArrayList<Integer>();
        clientData.forEach(entityId -> {
            Entity entity = player.level().getEntity(entityId.intValue());
            if (entity instanceof IMovingStorageEntity) {
                IMovingStorageEntity movingStorageEntity = (IMovingStorageEntity)entity;
                ISlotTracker slotTracker = movingStorageEntity.getStorageHolder().getStorageWrapper().getInventoryHandler().getSlotTracker();
                if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey)) {
                    entitiesWithStack.add((Integer)entityId);
                } else if (slotTracker.getItems().contains(stackKey.stack().getItem())) {
                    entitiesWithItem.add((Integer)entityId);
                }
            }
        });
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new MovingStorageSyncItemHighlightsPayload(entitiesWithStack, entitiesWithItem), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return new IItemActionPayloadHandler.HighlightResult(entitiesWithStack.size(), entitiesWithItem.size());
    }

    public Map<Vec3, InventoryHandler> getTargetInventories(Player player, List<Integer> clientData) {
        return clientData.stream().map(entityId -> player.level().getEntity(entityId.intValue())).filter(IMovingStorageEntity.class::isInstance).collect(Collectors.toMap(e -> e.getBoundingBox().getCenter(), e -> ((IMovingStorageEntity)e).getStorageHolder().getStorageWrapper().getInventoryHandler()));
    }
}

