/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SophisticatedMenuProvider;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.common.gui.MovingStorageSettingsContainerMenu;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModEntities;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageSettingsPayload;

public class MovingStorageContainerMenu<T extends Entity>
extends StorageContainerMenuBase<IStorageWrapper>
implements ISyncedContainer {
    protected final WeakReference<T> storageEntity;
    @Nullable
    private ContainerContents.SettingsData lastSettingsData = null;

    public MovingStorageContainerMenu(int containerId, Player player, int entityId) {
        this(ModEntities.MOVING_STORAGE_CONTAINER_TYPE.get(), containerId, player, entityId);
    }

    public MovingStorageContainerMenu(MenuType<?> menuType, int containerId, Player player, int entityId) {
        super(menuType, containerId, player, MovingStorageContainerMenu.getWrapper(player.level(), entityId), (IStorageWrapper)NoopStorageWrapper.INSTANCE, -1, false, MovingStorageContainerMenu.instantiateExtraSlots(player.level(), entityId));
        Entity entity = player.level().getEntity(entityId);
        if (!(entity instanceof IMovingStorageEntity)) {
            throw new IllegalArgumentException("Incorrect entity with id " + entityId + " expected to find IMovingStorageEntity");
        }
        IMovingStorageEntity movingStorageEntity = (IMovingStorageEntity)entity;
        this.storageEntity = new WeakReference<Entity>((Entity)movingStorageEntity);
        movingStorageEntity.getStorageHolder().startOpen(player, (Entity)this.storageEntity.get());
    }

    private static List<Slot> instantiateExtraSlots(Level level, int entityId) {
        Entity entity = level.getEntity(entityId);
        if (!(entity instanceof IMovingStorageEntity)) {
            return Collections.emptyList();
        }
        IMovingStorageEntity movingStorage = (IMovingStorageEntity)entity;
        return movingStorage.instantiateExtraSlots();
    }

    public Optional<T> getStorageEntity() {
        return Optional.ofNullable((Entity)this.storageEntity.get());
    }

    public void removed(Player player) {
        super.removed(player);
        this.getStorageEntity().ifPresent(storageEntity -> ((IMovingStorageEntity)storageEntity).getStorageHolder().stopOpen(player, (Entity)storageEntity));
    }

    private static IStorageWrapper getWrapper(Level level, int entityId) {
        Entity entity = level.getEntity(entityId);
        if (!(entity instanceof IMovingStorageEntity)) {
            return NoopStorageWrapper.INSTANCE;
        }
        IMovingStorageEntity movingStorage = (IMovingStorageEntity)entity;
        return movingStorage.getStorageHolder().getStorageWrapper();
    }

    public static MovingStorageContainerMenu<?> fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new MovingStorageContainerMenu(windowId, playerInventory.player, buffer.readInt());
    }

    public Optional<BlockPos> getBlockPosition() {
        return Optional.empty();
    }

    public Optional<Entity> getEntity() {
        return this.getStorageEntity().map(e -> e);
    }

    protected void onUpgradeChanged() {
        if (this.player.level().isClientSide()) {
            return;
        }
        ((ItemDisplaySettingsCategory)this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
    }

    public void openSettings() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.putString("action", "openSettings"));
            return;
        }
        this.getStorageEntity().ifPresent(entity -> this.player.openMenu((MenuProvider)new SophisticatedMenuProvider((w, p, pl) -> this.instantiateSettingsContainerMenu(w, pl, entity.getId()), (Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translGui("settings.title")), false), buffer -> buffer.writeInt(entity.getId())));
    }

    protected MovingStorageSettingsContainerMenu instantiateSettingsContainerMenu(int windowId, Player player, int entityId) {
        return new MovingStorageSettingsContainerMenu(windowId, player, entityId);
    }

    protected boolean storageItemHasChanged() {
        return false;
    }

    public boolean detectSettingsChangeAndReload() {
        if (this.player.level().isClientSide()) {
            return this.storageWrapper.getContentsUuid().map(uuid -> {
                MovingStorageData storage = MovingStorageData.get();
                if (storage.removeUpdatedStorageSettingsFlag((UUID)uuid)) {
                    this.storageWrapper.getSettingsHandler().reloadFrom(storage.getContents((UUID)uuid).settings());
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean stillValid(Player player) {
        return this.getStorageEntity().map(se -> player.distanceToSqr(se.position()) <= 64.0).orElse(false);
    }

    protected void sendStorageSettingsToClient() {
        if (this.player.level().isClientSide()) {
            return;
        }
        if (this.lastSettingsData == null || !this.lastSettingsData.equals((Object)this.storageWrapper.getSettingsHandler().getSettingsData())) {
            this.lastSettingsData = this.storageWrapper.getSettingsHandler().getSettingsData().copy();
            this.storageWrapper.getContentsUuid().ifPresent(uuid -> {
                ContainerContents.SettingsData settingsData = this.storageWrapper.getSettingsHandler().getSettingsData();
                Player patt0$temp = this.player;
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MovingStorageSettingsPayload((UUID)uuid, settingsData), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
    }

    public float getSlotFillPercentage(int slot) {
        IMovingStorageEntity entity = (IMovingStorageEntity)this.storageEntity.get();
        if (entity == null) {
            return 0.0f;
        }
        List slotFillRatios = entity.getStorageHolder().getStorageWrapper().getRenderDataHandler().getDisplayData().slotFillRatios();
        return slot > -1 && slot < slotFillRatios.size() ? ((Float)slotFillRatios.get(slot)).floatValue() : 0.0f;
    }
}

