/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedstorageinmotion.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class MovingStorageIngredient
implements ICustomIngredient {
    public static final MapCodec<MovingStorageIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.CODEC.fieldOf("moving_storage_item").forGetter(ingredient -> ingredient.movingStorageItem), (App)Item.CODEC.fieldOf("storage_item").forGetter(ingredient -> ingredient.storageItem)).apply((Applicative)instance, MovingStorageIngredient::new));
    private final Holder<Item> movingStorageItem;
    private final Holder<Item> storageItem;
    private final List<ItemStack> movingStorages;

    private MovingStorageIngredient(Holder<Item> movingStorageItem, Holder<Item> storageItem) {
        this.movingStorageItem = movingStorageItem;
        this.storageItem = storageItem;
        ArrayList storageItemCreativeTabItems = new ArrayList();
        Object object = storageItem.value();
        if (object instanceof BlockItemBase) {
            BlockItemBase itemBase = (BlockItemBase)object;
            itemBase.addCreativeTabItems(storageItemCreativeTabItems::add);
        }
        this.movingStorages = new ArrayList<ItemStack>();
        storageItemCreativeTabItems.forEach(storageItemStack -> {
            ItemStack movingStorageStack = new ItemStack(movingStorageItem);
            MovingStorageItem.setStorageItem(movingStorageStack, storageItemStack);
            this.movingStorages.add(movingStorageStack);
        });
    }

    public static MovingStorageIngredient of(Holder<Item> movingStorageItem, Item storageItem) {
        return new MovingStorageIngredient(movingStorageItem, (Holder<Item>)((Holder)BuiltInRegistries.ITEM.get(BuiltInRegistries.ITEM.getKey((Object)storageItem)).orElseThrow()));
    }

    public boolean test(ItemStack itemStack) {
        return itemStack.getItem() == this.movingStorageItem.value() && MovingStorageItem.getStorageItem((DataComponentHolder)itemStack).getItem() == this.storageItem.value();
    }

    public Stream<Holder<Item>> items() {
        return Stream.of(this.movingStorageItem);
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return ModItems.MOVING_STORAGE_INGREDIENT_TYPE.get();
    }

    public SlotDisplay display() {
        return new SlotDisplay.Composite(this.movingStorages.stream().map(SlotDisplay.ItemStackSlotDisplay::new).map(SlotDisplay.class::cast).toList());
    }
}

